/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

class DynamicSetProvider<T>
implements Provider<DynamicSet<T>> {
    private final TypeLiteral<T> type;
    @Inject
    private Injector injector;

    DynamicSetProvider(TypeLiteral<T> type) {
        this.type = type;
    }

    @Override
    public DynamicSet<T> get() {
        return new DynamicSet<T>(DynamicSetProvider.find(this.injector, this.type));
    }

    private static <T> List<AtomicReference<Provider<T>>> find(Injector src, TypeLiteral<T> type) {
        int cnt;
        List<Binding<T>> bindings = src.findBindingsByType(type);
        int n = cnt = bindings != null ? bindings.size() : 0;
        if (cnt == 0) {
            return Collections.emptyList();
        }
        ArrayList<AtomicReference<Provider<T>>> r = new ArrayList<AtomicReference<Provider<T>>>(cnt);
        for (Binding<T> b : bindings) {
            if (b.getKey().getAnnotation() == null) continue;
            r.add(new AtomicReference<Provider<T>>(b.getProvider()));
        }
        return r;
    }
}

