/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.restapi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class BinaryResult
implements Closeable {
    static final String OCTET_STREAM = "application/octet-stream";
    private String contentType = "application/octet-stream";
    private String characterEncoding;
    private long contentLength = -1L;
    private boolean gzip = true;
    private boolean base64 = false;
    private String attachmentName;

    public static BinaryResult create(String data) {
        try {
            return BinaryResult.create(data.getBytes("UTF-8")).setContentType("text/plain").setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM does not support UTF-8", e);
        }
    }

    public static BinaryResult create(byte[] data) {
        return new Array(data);
    }

    public static BinaryResult create(InputStream data) {
        return new Stream(data);
    }

    public String getContentType() {
        String enc = this.getCharacterEncoding();
        if (enc != null) {
            return this.contentType + "; charset=" + enc;
        }
        return this.contentType;
    }

    public BinaryResult setContentType(String contentType) {
        this.contentType = contentType != null ? contentType : OCTET_STREAM;
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public BinaryResult setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
        return this;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public BinaryResult setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
        return this;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public BinaryResult setContentLength(long len) {
        this.contentLength = len;
        return this;
    }

    public boolean canGzip() {
        return this.gzip;
    }

    public BinaryResult disableGzip() {
        this.gzip = false;
        return this;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public BinaryResult base64() {
        this.base64 = true;
        return this;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        if (this.getContentLength() >= 0L) {
            return String.format("BinaryResult[Content-Type: %s, Content-Length: %d]", this.getContentType(), this.getContentLength());
        }
        return String.format("BinaryResult[Content-Type: %s, Content-Length: unknown]", this.getContentType());
    }

    private static class Stream
    extends BinaryResult {
        private final InputStream src;

        Stream(InputStream src) {
            this.src = src;
        }

        @Override
        public void writeTo(OutputStream dst) throws IOException {
            int n;
            byte[] tmp = new byte[4096];
            while (0 < (n = this.src.read(tmp))) {
                dst.write(tmp, 0, n);
            }
        }

        @Override
        public void close() throws IOException {
            this.src.close();
        }
    }

    private static class Array
    extends BinaryResult {
        private final byte[] data;

        Array(byte[] data) {
            this.data = data;
            this.setContentLength(data.length);
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            os.write(this.data);
        }
    }
}

