/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.WebSessionManager;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Provider;
import com.google.inject.servlet.RequestScoped;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.GitSmartHttpTools;

@RequestScoped
public abstract class CacheBasedWebSession
implements WebSession {
    private static final String ACCOUNT_COOKIE = "GerritAccount";
    protected static final long MAX_AGE_MINUTES = TimeUnit.HOURS.toMinutes(12L);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final WebSessionManager manager;
    private final AuthConfig authConfig;
    private final Provider<AnonymousUser> anonymousProvider;
    private final IdentifiedUser.RequestFactory identified;
    private final EnumSet<AccessPath> okPaths = EnumSet.of(AccessPath.UNKNOWN);
    private Cookie outCookie;
    private WebSessionManager.Key key;
    private WebSessionManager.Val val;
    private CurrentUser user;

    protected CacheBasedWebSession(HttpServletRequest request, HttpServletResponse response, WebSessionManager manager, AuthConfig authConfig, Provider<AnonymousUser> anonymousProvider, IdentifiedUser.RequestFactory identified) {
        String cookie;
        this.request = request;
        this.response = response;
        this.manager = manager;
        this.authConfig = authConfig;
        this.anonymousProvider = anonymousProvider;
        this.identified = identified;
        if (!(request.getRequestURI() != null && GitSmartHttpTools.isGitClient(request) || (cookie = this.readCookie()) == null)) {
            this.key = new WebSessionManager.Key(cookie);
            this.val = manager.get(this.key);
            if (this.val != null && this.val.needsCookieRefresh()) {
                this.val = manager.createVal(this.key, this.val);
            }
            String token = request.getHeader("X-Gerrit-Auth");
            if (this.val != null && token != null && token.equals(this.val.getAuth())) {
                this.okPaths.add(AccessPath.REST_API);
            }
        }
    }

    private String readCookie() {
        Cookie[] all = this.request.getCookies();
        if (all != null) {
            for (Cookie c : all) {
                if (!ACCOUNT_COOKIE.equals(c.getName())) continue;
                String v = c.getValue();
                return v != null && !"".equals(v) ? v : null;
            }
        }
        return null;
    }

    @Override
    public boolean isSignedIn() {
        return this.val != null;
    }

    @Override
    public String getXGerritAuth() {
        return this.isSignedIn() ? this.val.getAuth() : null;
    }

    @Override
    public boolean isValidXGerritAuth(String keyIn) {
        return keyIn.equals(this.getXGerritAuth());
    }

    @Override
    public boolean isAccessPathOk(AccessPath path) {
        return this.okPaths.contains((Object)path);
    }

    @Override
    public void setAccessPathOk(AccessPath path, boolean ok) {
        if (ok) {
            this.okPaths.add(path);
        } else {
            this.okPaths.remove((Object)path);
        }
    }

    @Override
    public AccountExternalId.Key getLastLoginExternalId() {
        return this.val != null ? this.val.getExternalId() : null;
    }

    @Override
    public CurrentUser getCurrentUser() {
        if (this.user == null) {
            this.user = this.isSignedIn() ? this.identified.create(this.val.getAccountId()) : (CurrentUser)this.anonymousProvider.get();
        }
        return this.user;
    }

    @Override
    public void login(AuthResult res, boolean rememberMe) {
        Account.Id id = res.getAccountId();
        AccountExternalId.Key identity = res.getExternalId();
        if (this.val != null) {
            this.manager.destroy(this.key);
        }
        this.key = this.manager.createKey(id);
        this.val = this.manager.createVal(this.key, id, rememberMe, identity, null, null);
        this.saveCookie();
    }

    @Override
    public void setUserAccountId(Account.Id id) {
        this.key = new WebSessionManager.Key("id:" + id);
        this.val = new WebSessionManager.Val(id, 0L, false, null, 0L, null, null);
        this.user = this.identified.runAs(id, this.user);
    }

    @Override
    public void logout() {
        if (this.val != null) {
            this.manager.destroy(this.key);
            this.key = null;
            this.val = null;
            this.saveCookie();
        }
    }

    @Override
    public String getSessionId() {
        return this.val != null ? this.val.getSessionId() : null;
    }

    private void saveCookie() {
        int ageSeconds;
        String token;
        if (this.response == null) {
            return;
        }
        if (this.key == null) {
            token = "";
            ageSeconds = 0;
        } else {
            token = this.key.getToken();
            ageSeconds = this.manager.getCookieAge(this.val);
        }
        String path = this.authConfig.getCookiePath();
        if ((path == null || path.isEmpty()) && ((path = this.request.getContextPath()) == null || path.isEmpty())) {
            path = "/";
        }
        if (this.outCookie != null) {
            throw new IllegalStateException("Cookie GerritAccount was set");
        }
        this.outCookie = new Cookie(ACCOUNT_COOKIE, token);
        this.outCookie.setSecure(CacheBasedWebSession.isSecure(this.request));
        this.outCookie.setPath(path);
        this.outCookie.setMaxAge(ageSeconds);
        this.outCookie.setSecure(this.authConfig.getCookieSecure());
        this.response.addCookie(this.outCookie);
    }

    private static boolean isSecure(HttpServletRequest req) {
        return req.isSecure() || "https".equals(req.getScheme());
    }
}

