/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.Nullable;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;

public class CanonicalWebUrl {
    private final Provider<String> configured;

    @Inject
    CanonicalWebUrl(@com.google.gerrit.server.config.CanonicalWebUrl @Nullable Provider<String> provider) {
        this.configured = provider;
    }

    public String get(HttpServletRequest req) {
        String url = this.configured.get();
        return url != null ? url : CanonicalWebUrl.computeFromRequest(req);
    }

    static String computeFromRequest(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        url.setLength(url.length() - req.getServletPath().length());
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        return url.toString();
    }
}

