/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

class CookieBase64 {
    private static final char[] enc = new char[64];

    private static int fill(char[] out, int o, char f, int l) {
        for (char c = f; c <= l; c = (char)(c + '\u0001')) {
            out[o++] = c;
        }
        return o;
    }

    static String encode(byte[] in) {
        int d;
        StringBuilder out = new StringBuilder(in.length * 4 / 3);
        int len2 = in.length - 2;
        for (d = 0; d < len2; d += 3) {
            CookieBase64.encode3to4(out, in, d, 3);
        }
        if (d < in.length) {
            CookieBase64.encode3to4(out, in, d, in.length - d);
        }
        return out.toString();
    }

    private static void encode3to4(StringBuilder out, byte[] in, int inOffset, int numSigBytes) {
        int inBuff = (numSigBytes > 0 ? in[inOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? in[inOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? in[inOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                out.append(enc[inBuff >>> 18]);
                out.append(enc[inBuff >>> 12 & 0x3F]);
                out.append(enc[inBuff >>> 6 & 0x3F]);
                out.append(enc[inBuff & 0x3F]);
                break;
            }
            case 2: {
                out.append(enc[inBuff >>> 18]);
                out.append(enc[inBuff >>> 12 & 0x3F]);
                out.append(enc[inBuff >>> 6 & 0x3F]);
                break;
            }
            case 1: {
                out.append(enc[inBuff >>> 18]);
                out.append(enc[inBuff >>> 12 & 0x3F]);
                break;
            }
        }
    }

    private CookieBase64() {
    }

    static {
        int o = 0;
        o = CookieBase64.fill(enc, o, 'a', 122);
        o = CookieBase64.fill(enc, o, 'A', 90);
        o = CookieBase64.fill(enc, o, '0', 57);
        CookieBase64.enc[o++] = 45;
        CookieBase64.enc[o] = 46;
    }
}

