/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Strings;
import com.google.gerrit.audit.AuditEvent;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.util.TimeUtil;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
class HttpLogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final DynamicItem<WebSession> webSession;
    private final Provider<String> urlProvider;
    private final String logoutUrl;
    private final AuditService audit;

    @Inject
    HttpLogoutServlet(AuthConfig authConfig, DynamicItem<WebSession> webSession, @CanonicalWebUrl @Nullable Provider<String> urlProvider, AccountManager accountManager, AuditService audit) {
        this.webSession = webSession;
        this.urlProvider = urlProvider;
        this.logoutUrl = authConfig.getLogoutURL();
        this.audit = audit;
    }

    private void doLogout(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        this.webSession.get().logout();
        if (this.logoutUrl != null) {
            rsp.sendRedirect(this.logoutUrl);
        } else {
            String url = this.urlProvider.get();
            if (Strings.isNullOrEmpty(url)) {
                url = req.getContextPath();
            }
            if (Strings.isNullOrEmpty(url)) {
                url = "/";
            }
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            rsp.sendRedirect(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String sid = this.webSession.get().getSessionId();
        CurrentUser currentUser = this.webSession.get().getCurrentUser();
        String what = "sign out";
        long when = TimeUtil.nowMs();
        try {
            this.doLogout(req, rsp);
        }
        finally {
            this.audit.dispatch(new AuditEvent(sid, currentUser, "sign out", when, null, null));
        }
    }
}

