/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.servlet.RequestScoped;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

@RequestScoped
class HttpRemotePeerProvider
implements Provider<SocketAddress> {
    private final HttpServletRequest req;

    @Inject
    HttpRemotePeerProvider(HttpServletRequest r) {
        this.req = r;
    }

    @Override
    public SocketAddress get() {
        String addr = this.req.getRemoteAddr();
        int port = this.req.getRemotePort();
        try {
            return new InetSocketAddress(InetAddress.getByName(addr), port);
        }
        catch (UnknownHostException e) {
            throw new ProvisionException("Cannot get @RemotePeer", e);
        }
    }
}

