/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.auth.NoSuchUserException;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ProjectBasicAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ProjectBasicAuthFilter.class);
    public static final String REALM_NAME = "Gerrit Code Review";
    private static final String AUTHORIZATION = "Authorization";
    private static final String LIT_BASIC = "Basic ";
    private final DynamicItem<WebSession> session;
    private final AccountCache accountCache;
    private final AccountManager accountManager;
    private final AuthConfig authConfig;

    @Inject
    ProjectBasicAuthFilter(DynamicItem<WebSession> session, AccountCache accountCache, AccountManager accountManager, AuthConfig authConfig) {
        this.session = session;
        this.accountCache = accountCache;
        this.accountManager = accountManager;
        this.authConfig = authConfig;
    }

    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Response rsp = new Response((HttpServletResponse)response);
        if (this.verify(req, rsp)) {
            chain.doFilter(req, rsp);
        }
    }

    private boolean verify(HttpServletRequest req, Response rsp) throws IOException {
        AccountState who;
        String hdr = req.getHeader(AUTHORIZATION);
        if (hdr == null || !hdr.startsWith(LIT_BASIC)) {
            return true;
        }
        byte[] decoded = Base64.decodeBase64(hdr.substring(LIT_BASIC.length()));
        String usernamePassword = new String(decoded, this.encoding(req));
        int splitPos = usernamePassword.indexOf(58);
        if (splitPos < 1) {
            rsp.sendError(401);
            return false;
        }
        String username = usernamePassword.substring(0, splitPos);
        String password = usernamePassword.substring(splitPos + 1);
        if (Strings.isNullOrEmpty(password)) {
            rsp.sendError(401);
            return false;
        }
        if (this.authConfig.isUserNameToLowerCase()) {
            username = username.toLowerCase(Locale.US);
        }
        if ((who = this.accountCache.getByUsername(username)) == null || !who.getAccount().isActive()) {
            log.warn("Authentication failed for " + username + ": account inactive or not provisioned in Gerrit");
            rsp.sendError(401);
            return false;
        }
        if (!this.authConfig.isLdapAuthType() && !this.passwordMatchesTheUserGeneratedOne(who, username, password)) {
            log.warn("Authentication failed for " + username + ": password does not match the one stored in Gerrit");
            rsp.sendError(401);
            return false;
        }
        AuthRequest whoAuth = AuthRequest.forUser(username);
        whoAuth.setPassword(password);
        try {
            AuthResult whoAuthResult = this.accountManager.authenticate(whoAuth);
            WebSession ws = this.session.get();
            ws.setUserAccountId(whoAuthResult.getAccountId());
            ws.setAccessPathOk(AccessPath.GIT, true);
            ws.setAccessPathOk(AccessPath.REST_API, true);
            return true;
        }
        catch (NoSuchUserException e) {
            if (password.equals(who.getPassword(who.getUserName()))) {
                WebSession ws = this.session.get();
                ws.setUserAccountId(who.getAccount().getId());
                ws.setAccessPathOk(AccessPath.GIT, true);
                ws.setAccessPathOk(AccessPath.REST_API, true);
                return true;
            }
            log.warn("Authentication failed for " + username, e);
            rsp.sendError(401);
            return false;
        }
        catch (AccountException e) {
            log.warn("Authentication failed for " + username, e);
            rsp.sendError(401);
            return false;
        }
    }

    private boolean passwordMatchesTheUserGeneratedOne(AccountState who, String username, String password) {
        String accountPassword = who.getPassword(username);
        return accountPassword != null && password != null && accountPassword.equals(password);
    }

    private String encoding(HttpServletRequest req) {
        return Objects.firstNonNull(req.getCharacterEncoding(), "UTF-8");
    }

    class Response
    extends HttpServletResponseWrapper {
        private static final String WWW_AUTHENTICATE = "WWW-Authenticate";

        Response(HttpServletResponse rsp) {
            super(rsp);
        }

        private void status(int sc) {
            if (sc == 401) {
                StringBuilder v = new StringBuilder();
                v.append(ProjectBasicAuthFilter.LIT_BASIC);
                v.append("realm=\"").append(ProjectBasicAuthFilter.REALM_NAME).append("\"");
                this.setHeader(WWW_AUTHENTICATE, v.toString());
            } else if (this.containsHeader(WWW_AUTHENTICATE)) {
                this.setHeader(WWW_AUTHENTICATE, null);
            }
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            this.status(sc);
            super.sendError(sc, msg);
        }

        @Override
        public void sendError(int sc) throws IOException {
            this.status(sc);
            super.sendError(sc);
        }

        @Override
        @Deprecated
        public void setStatus(int sc, String sm) {
            this.status(sc);
            super.setStatus(sc, sm);
        }

        @Override
        public void setStatus(int sc) {
            this.status(sc);
            super.setStatus(sc);
        }
    }
}

