/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.HttpRequestContext;
import com.google.gerrit.server.RequestCleanup;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@Singleton
public class RequestContextFilter
implements Filter {
    private final Provider<RequestCleanup> cleanup;
    private final Provider<HttpRequestContext> requestContext;
    private final ThreadLocalRequestContext local;

    public static Module module() {
        return new ServletModule(){

            @Override
            protected void configureServlets() {
                this.filter("/*", new String[0]).through(RequestContextFilter.class);
            }
        };
    }

    @Inject
    RequestContextFilter(Provider<RequestCleanup> r, Provider<HttpRequestContext> c, ThreadLocalRequestContext l) {
        this.cleanup = r;
        this.requestContext = c;
        this.local = l;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestContext old = this.local.setContext(this.requestContext.get());
        try {
            try {
                chain.doFilter(request, response);
            }
            finally {
                this.cleanup.get().run();
            }
        }
        finally {
            this.local.setContext(old);
        }
    }
}

