/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.server.CurrentUser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

@Singleton
class RequireIdentifiedUserFilter
implements Filter {
    private final Provider<CurrentUser> user;

    @Inject
    RequireIdentifiedUserFilter(Provider<CurrentUser> user) {
        this.user = user;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.user.get().isIdentifiedUser()) {
            chain.doFilter(request, response);
        } else {
            HttpServletResponse res = (HttpServletResponse)response;
            res.sendError(401);
        }
    }
}

