/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.become;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.LoginUrlToken;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.template.SiteHeaderFooter;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.AuthResult;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
class BecomeAnyAccountLoginServlet
extends HttpServlet {
    private static final boolean IS_DEV = Boolean.getBoolean("Gerrit.GwtDevMode");
    private final SchemaFactory<ReviewDb> schema;
    private final DynamicItem<WebSession> webSession;
    private final AccountManager accountManager;
    private final SiteHeaderFooter headers;

    @Inject
    BecomeAnyAccountLoginServlet(DynamicItem<WebSession> ws, SchemaFactory<ReviewDb> sf, AccountManager am, ServletContext servletContext, SiteHeaderFooter shf) {
        this.webSession = ws;
        this.schema = sf;
        this.accountManager = am;
        this.headers = shf;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        this.doPost(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        AuthResult res;
        CacheHeaders.setNotCacheable(rsp);
        if ("create_account".equals(req.getParameter("action"))) {
            res = this.create();
        } else if (req.getParameter("user_name") != null) {
            res = this.byUserName(rsp, req.getParameter("user_name"));
        } else if (req.getParameter("preferred_email") != null) {
            res = this.byPreferredEmail(rsp, req.getParameter("preferred_email"));
        } else if (req.getParameter("account_id") != null) {
            res = this.byAccountId(rsp, req.getParameter("account_id"));
        } else {
            byte[] raw;
            try {
                raw = this.prepareHtmlOutput();
            }
            catch (OrmException e) {
                throw new ServletException(e);
            }
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding("UTF-8");
            rsp.setContentLength(raw.length);
            try (ServletOutputStream out = rsp.getOutputStream();){
                out.write(raw);
            }
            return;
        }
        if (res != null) {
            this.webSession.get().login(res, false);
            StringBuilder rdr = new StringBuilder();
            rdr.append(req.getContextPath());
            rdr.append("/");
            if (IS_DEV && req.getParameter("gwt.codesvr") != null) {
                if (rdr.indexOf("?") < 0) {
                    rdr.append("?");
                } else {
                    rdr.append("&");
                }
                rdr.append("gwt.codesvr=").append(req.getParameter("gwt.codesvr"));
            }
            if (res.isNew()) {
                rdr.append("#/register");
            } else {
                rdr.append(LoginUrlToken.getToken(req));
            }
            rsp.sendRedirect(rdr.toString());
        } else {
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding("UTF-8");
            PrintWriter out = rsp.getWriter();
            ((Writer)out).write("<html>");
            ((Writer)out).write("<body>");
            ((Writer)out).write("<h1>Account Not Found</h1>");
            ((Writer)out).write("</body>");
            ((Writer)out).write("</html>");
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] prepareHtmlOutput() throws IOException, OrmException {
        Element devmode;
        String pageName = "BecomeAnyAccount.html";
        Document doc = this.headers.parse(this.getClass(), "BecomeAnyAccount.html");
        if (doc == null) {
            throw new FileNotFoundException("No BecomeAnyAccount.html in webapp");
        }
        if (!IS_DEV && (devmode = HtmlDomUtil.find(doc, "gwtdevmode")) != null) {
            devmode.getParentNode().removeChild(devmode);
        }
        Element userlistElement = HtmlDomUtil.find(doc, "userlist");
        try (ReviewDb db = this.schema.open();){
            ResultSet<Account> accounts = db.accounts().firstNById(100);
            for (Account a : accounts) {
                String displayName = a.getUserName() != null ? a.getUserName() : (a.getFullName() != null && !a.getFullName().isEmpty() ? a.getFullName() : (a.getPreferredEmail() != null ? a.getPreferredEmail() : a.getId().toString()));
                Element linkElement = doc.createElement("a");
                linkElement.setAttribute("href", "?account_id=" + a.getId().toString());
                linkElement.setTextContent(displayName);
                userlistElement.appendChild(linkElement);
                userlistElement.appendChild(doc.createElement("br"));
            }
        }
        return HtmlDomUtil.toUTF8(doc);
    }

    private AuthResult auth(Account account) {
        if (account != null) {
            return new AuthResult(account.getId(), null, false);
        }
        return null;
    }

    private AuthResult auth(AccountExternalId account) {
        if (account != null) {
            return new AuthResult(account.getAccountId(), null, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthResult byUserName(HttpServletResponse rsp, String userName) {
        AuthResult authResult;
        ReviewDb db = this.schema.open();
        try {
            AccountExternalId.Key key = new AccountExternalId.Key("username:", userName);
            authResult = this.auth(db.accountExternalIds().get(key));
        }
        catch (Throwable throwable) {
            try {
                db.close();
                throw throwable;
            }
            catch (OrmException e) {
                this.getServletContext().log("cannot query database", e);
                return null;
            }
        }
        db.close();
        return authResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthResult byPreferredEmail(HttpServletResponse rsp, String email) {
        AuthResult authResult;
        ReviewDb db = this.schema.open();
        try {
            List<Account> matches = db.accounts().byPreferredEmail(email).toList();
            authResult = matches.size() == 1 ? this.auth(matches.get(0)) : null;
        }
        catch (Throwable throwable) {
            try {
                db.close();
                throw throwable;
            }
            catch (OrmException e) {
                this.getServletContext().log("cannot query database", e);
                return null;
            }
        }
        db.close();
        return authResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthResult byAccountId(HttpServletResponse rsp, String idStr) {
        AuthResult authResult;
        Account.Id id;
        try {
            id = Account.Id.parse(idStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        ReviewDb db = this.schema.open();
        try {
            authResult = this.auth(db.accounts().get(id));
        }
        catch (Throwable throwable) {
            try {
                db.close();
                throw throwable;
            }
            catch (OrmException e) {
                this.getServletContext().log("cannot query database", e);
                return null;
            }
        }
        db.close();
        return authResult;
    }

    private AuthResult create() {
        String fakeId = "uuid:" + UUID.randomUUID();
        try {
            return this.accountManager.authenticate(new AuthRequest(fakeId));
        }
        catch (AccountException e) {
            this.getServletContext().log("cannot create new account", e);
            return null;
        }
    }
}

