/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.gitweb;

import com.google.gerrit.httpd.GitWebConfig;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.util.IO;

@Singleton
class GitWebJavaScriptServlet
extends HttpServlet {
    private final long modified;
    private final byte[] raw;

    @Inject
    GitWebJavaScriptServlet(GitWebConfig gitWebConfig) throws IOException {
        byte[] png;
        File src = gitWebConfig.getGitwebJS();
        if (src != null) {
            try {
                png = IO.readFully(src);
            }
            catch (FileNotFoundException e) {
                png = null;
            }
            this.modified = src.lastModified();
        } else {
            this.modified = -1L;
            png = null;
        }
        this.raw = png;
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (this.raw != null) {
            rsp.setContentType("text/javascript");
            rsp.setContentLength(this.raw.length);
            rsp.setDateHeader("Last-Modified", this.modified);
            CacheHeaders.setCacheable(req, rsp, 5L, TimeUnit.MINUTES);
            try (ServletOutputStream os = rsp.getOutputStream();){
                os.write(this.raw);
            }
        } else {
            CacheHeaders.setNotCacheable(rsp);
            rsp.sendError(404);
        }
    }
}

