/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.FileTypeRegistry;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import eu.medsea.mimeutil.MimeType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.NB;

@Singleton
public class CatServlet
extends HttpServlet {
    private static final MimeType ZIP = new MimeType("application/zip");
    private final Provider<ReviewDb> requestDb;
    private final GitRepositoryManager repoManager;
    private final SecureRandom rng;
    private final FileTypeRegistry registry;
    private final ChangeControl.Factory changeControl;

    @Inject
    CatServlet(GitRepositoryManager grm, Provider<ReviewDb> sf, FileTypeRegistry ftr, ChangeControl.Factory ccf) {
        this.requestDb = sf;
        this.repoManager = grm;
        this.rng = new SecureRandom();
        this.registry = ftr;
        this.changeControl = ccf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        OutputStream out;
        ZipOutputStream zo;
        ObjectLoader blobLoader;
        String suffix;
        RevCommit fromCommit;
        Repository repo;
        PatchSet patchSet;
        Project project;
        Patch.Key patchKey;
        int side;
        String keyStr = req.getPathInfo();
        if (!(keyStr = Url.decode(keyStr)).startsWith("/")) {
            rsp.sendError(404);
            return;
        }
        int c = (keyStr = keyStr.substring(1)).lastIndexOf(94);
        if (c == 0) {
            rsp.sendError(404);
            return;
        }
        if (c < 0) {
            side = 0;
        } else {
            try {
                side = Integer.parseInt(keyStr.substring(c + 1));
                keyStr = keyStr.substring(0, c);
            }
            catch (NumberFormatException e) {
                rsp.sendError(404);
                return;
            }
        }
        try {
            patchKey = Patch.Key.parse(keyStr);
        }
        catch (NumberFormatException e) {
            rsp.sendError(404);
            return;
        }
        Change.Id changeId = patchKey.getParentKey().getParentKey();
        try {
            ReviewDb db = this.requestDb.get();
            ChangeControl control = this.changeControl.validateFor(changeId);
            project = control.getProject();
            patchSet = db.patchSets().get(patchKey.getParentKey());
            if (patchSet == null) {
                rsp.sendError(404);
                return;
            }
        }
        catch (NoSuchChangeException e) {
            rsp.sendError(404);
            return;
        }
        catch (OrmException e) {
            this.getServletContext().log("Cannot query database", e);
            rsp.sendError(500);
            return;
        }
        try {
            repo = this.repoManager.openRepository(project.getNameKey());
        }
        catch (RepositoryNotFoundException e) {
            this.getServletContext().log("Cannot open repository", e);
            rsp.sendError(500);
            return;
        }
        String path = patchKey.getFileName();
        try {
            ObjectReader reader = repo.newObjectReader();
            try {
                RevWalk rw = new RevWalk(reader);
                RevCommit c2 = rw.parseCommit(ObjectId.fromString(patchSet.getRevision().get()));
                if (side == 0) {
                    fromCommit = c2;
                    suffix = "new";
                } else if (1 <= side && side - 1 < c2.getParentCount()) {
                    fromCommit = rw.parseCommit(c2.getParent(side - 1));
                    suffix = c2.getParentCount() == 1 ? "old" : "old" + side;
                } else {
                    rsp.sendError(404);
                    return;
                }
                TreeWalk tw = TreeWalk.forPath(reader, path, fromCommit.getTree());
                if (tw == null) {
                    rsp.sendError(404);
                    return;
                }
                if (tw.getFileMode(0).getObjectType() != 3) {
                    rsp.sendError(500);
                    return;
                }
                blobLoader = reader.open(tw.getObjectId(0), 3);
            }
            finally {
                reader.release();
            }
        }
        catch (IOException e) {
            this.getServletContext().log("Cannot read repository", e);
            rsp.sendError(500);
            return;
        }
        catch (RuntimeException e) {
            this.getServletContext().log("Cannot read repository", e);
            rsp.sendError(500);
            return;
        }
        finally {
            repo.close();
        }
        byte[] raw = blobLoader.isLarge() ? null : blobLoader.getCachedBytes();
        long when = (long)fromCommit.getCommitTime() * 1000L;
        rsp.setDateHeader("Last-Modified", when);
        CacheHeaders.setNotCacheable(rsp);
        MimeType contentType = this.registry.getMimeType(path, raw);
        if (!this.registry.isSafeInline(contentType)) {
            rsp.setContentType(ZIP.toString());
            rsp.setHeader("Content-Disposition", "attachment; filename=\"" + CatServlet.safeFileName(path, suffix) + ".zip" + "\"");
            zo = new ZipOutputStream(rsp.getOutputStream());
            ZipEntry e = new ZipEntry(CatServlet.safeFileName(path, this.rand(req, suffix)));
            e.setComment(fromCommit.name() + ":" + path);
            e.setSize(blobLoader.getSize());
            e.setTime(when);
            zo.putNextEntry(e);
            out = zo;
        } else {
            rsp.setContentType(contentType.toString());
            rsp.setHeader("Content-Length", "" + blobLoader.getSize());
            out = rsp.getOutputStream();
            zo = null;
        }
        if (raw != null) {
            out.write(raw);
        } else {
            blobLoader.copyTo(out);
        }
        if (zo != null) {
            zo.closeEntry();
        }
        out.close();
    }

    private static String safeFileName(String fileName, String suffix) {
        int slash = fileName.lastIndexOf(47);
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        StringBuilder r = new StringBuilder(fileName.length());
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '_' || c == '-' || c == '.' || c == '@') {
                r.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                r.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                r.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                r.append(c);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                r.append('-');
                continue;
            }
            r.append('_');
        }
        fileName = r.toString();
        int ext = fileName.lastIndexOf(46);
        if (ext <= 0) {
            return fileName + "_" + suffix;
        }
        return fileName.substring(0, ext) + "_" + suffix + fileName.substring(ext);
    }

    private String rand(HttpServletRequest req, String suffix) throws UnsupportedEncodingException {
        MessageDigest md = Constants.newMessageDigest();
        byte[] buf = new byte[8];
        NB.encodeInt32(buf, 0, req.getRemotePort());
        md.update(req.getRemoteAddr().getBytes("UTF-8"));
        md.update(buf, 0, 4);
        NB.encodeInt64(buf, 0, TimeUtil.nowMs());
        md.update(buf, 0, 8);
        this.rng.nextBytes(buf);
        md.update(buf, 0, 8);
        return suffix + "-" + ObjectId.fromRaw(md.digest()).name();
    }
}

