/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.base.CharMatcher;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StaticServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StaticServlet.class);
    private static final String JS = "application/x-javascript";
    private static final Map<String, String> MIME_TYPES = Maps.newHashMap();
    private final File staticBase;
    private final String staticBasePath;
    private final boolean refresh;
    private final LoadingCache<String, Resource> cache;

    private static String contentType(String name) {
        int dot = name.lastIndexOf(46);
        String ext = 0 < dot ? name.substring(dot + 1) : "";
        String type = MIME_TYPES.get(ext);
        return type != null ? type : "application/octet-stream";
    }

    @Inject
    StaticServlet(@GerritServerConfig Config cfg, SitePaths site) {
        File f;
        try {
            f = site.static_dir.getCanonicalFile();
        }
        catch (IOException e) {
            f = site.static_dir.getAbsoluteFile();
        }
        this.staticBase = f;
        this.staticBasePath = this.staticBase.getPath() + File.separator;
        this.refresh = cfg.getBoolean("site", "refreshHeaderFooter", true);
        this.cache = CacheBuilder.newBuilder().maximumWeight(0x100000L).weigher(new Weigher<String, Resource>(){

            @Override
            public int weigh(String name, Resource r) {
                return 2 * name.length() + r.raw.length;
            }
        }).build(new CacheLoader<String, Resource>(){

            @Override
            public Resource load(String name) throws Exception {
                return StaticServlet.this.loadResource(name);
            }
        });
    }

    @Nullable
    Resource getResource(String name) {
        try {
            return this.cache.get(name);
        }
        catch (ExecutionException e) {
            log.warn(String.format("Cannot load static resource %s", name), e);
            return null;
        }
    }

    private Resource getResource(HttpServletRequest req) throws ExecutionException {
        String name = CharMatcher.is('/').trimFrom(req.getPathInfo());
        if (StaticServlet.isUnreasonableName(name)) {
            return Resource.NOT_FOUND;
        }
        Resource r = this.cache.get(name);
        if (r == Resource.NOT_FOUND) {
            return Resource.NOT_FOUND;
        }
        if (this.refresh && r.isStale()) {
            this.cache.invalidate(name);
            r = this.cache.get(name);
        }
        return r;
    }

    private static boolean isUnreasonableName(String name) {
        if (name.length() < 1) {
            return true;
        }
        if (name.contains("\\")) {
            return true;
        }
        if (name.startsWith("../")) {
            return true;
        }
        if (name.contains("/../")) {
            return true;
        }
        if (name.contains("/./")) {
            return true;
        }
        return name.contains("//");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        byte[] gz;
        Resource r;
        try {
            r = this.getResource(req);
        }
        catch (ExecutionException e) {
            log.warn(String.format("Cannot load static resource %s", req.getPathInfo()), e);
            CacheHeaders.setNotCacheable(rsp);
            rsp.setStatus(500);
            return;
        }
        String e = req.getParameter("e");
        if (r == Resource.NOT_FOUND || e != null && !r.etag.equals(e)) {
            CacheHeaders.setNotCacheable(rsp);
            rsp.setStatus(404);
            return;
        }
        if (r.etag.equals(req.getHeader("If-None-Match"))) {
            rsp.setStatus(304);
            return;
        }
        byte[] tosend = r.raw;
        if (!r.contentType.equals(JS) && RPCServletUtils.acceptsGzipEncoding(req) && (gz = HtmlDomUtil.compress(tosend)).length + 24 < tosend.length) {
            rsp.setHeader("Content-Encoding", "gzip");
            tosend = gz;
        }
        if (e != null && r.etag.equals(e)) {
            CacheHeaders.setCacheable(req, rsp, 360L, TimeUnit.DAYS, false);
        } else {
            CacheHeaders.setCacheable(req, rsp, 15L, TimeUnit.MINUTES, this.refresh);
        }
        rsp.setHeader("ETag", r.etag);
        rsp.setContentType(r.contentType);
        rsp.setContentLength(tosend.length);
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(tosend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource loadResource(String name) throws IOException {
        byte[] raw;
        FileInputStream in;
        File p = new File(this.staticBase, name);
        try {
            p = p.getCanonicalFile();
        }
        catch (IOException e) {
            return Resource.NOT_FOUND;
        }
        if (!p.getPath().startsWith(this.staticBasePath)) {
            return Resource.NOT_FOUND;
        }
        long ts = p.lastModified();
        try {
            in = new FileInputStream(p);
        }
        catch (FileNotFoundException e) {
            return Resource.NOT_FOUND;
        }
        try {
            raw = ByteStreams.toByteArray(in);
        }
        finally {
            in.close();
        }
        return new Resource(p, ts, StaticServlet.contentType(name), raw);
    }

    static {
        MIME_TYPES.put("html", "text/html");
        MIME_TYPES.put("htm", "text/html");
        MIME_TYPES.put("js", JS);
        MIME_TYPES.put("css", "text/css");
        MIME_TYPES.put("rtf", "text/rtf");
        MIME_TYPES.put("txt", "text/plain");
        MIME_TYPES.put("text", "text/plain");
        MIME_TYPES.put("pdf", "application/pdf");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("tiff", "image/tiff");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("svg", "image/svg+xml");
    }

    static class Resource {
        static final Resource NOT_FOUND = new Resource(null, -1L, "", new byte[0]);
        final File src;
        final long lastModified;
        final String contentType;
        final String etag;
        final byte[] raw;

        Resource(File src, long lastModified, String contentType, byte[] raw) {
            this.src = src;
            this.lastModified = lastModified;
            this.contentType = contentType;
            this.etag = Hashing.md5().hashBytes(raw).toString();
            this.raw = raw;
        }

        boolean isStale() {
            return this.lastModified != this.src.lastModified();
        }
    }
}

