/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.gerrit.common.errors.CorruptEntityException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.httpd.rpc.BaseServiceImplementation;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.NoSuchRefException;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtorm.server.OrmException;
import java.util.concurrent.Callable;

public abstract class Handler<T>
implements Callable<T> {
    public static <T> Handler<T> wrap(final Callable<T> r) {
        return new Handler<T>(){

            @Override
            public T call() throws Exception {
                return r.call();
            }
        };
    }

    public final void to(AsyncCallback<T> callback) {
        try {
            T r = this.call();
            if (r != null) {
                callback.onSuccess(r);
            }
        }
        catch (NoSuchProjectException e) {
            callback.onFailure(new NoSuchEntityException());
        }
        catch (NoSuchRefException e) {
            callback.onFailure(new NoSuchEntityException());
        }
        catch (NoSuchChangeException e) {
            callback.onFailure(new NoSuchEntityException());
        }
        catch (OrmException e) {
            if (e.getCause() instanceof BaseServiceImplementation.Failure) {
                callback.onFailure(e.getCause().getCause());
            } else if (e.getCause() instanceof CorruptEntityException) {
                callback.onFailure(e.getCause());
            } else if (e.getCause() instanceof NoSuchEntityException) {
                callback.onFailure(e.getCause());
            } else {
                callback.onFailure(e);
            }
        }
        catch (BaseServiceImplementation.Failure e) {
            callback.onFailure(e.getCause());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    @Override
    public abstract T call() throws Exception;
}

