/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.gerrit.httpd.rpc.GerritJsonServlet;
import com.google.gerrit.httpd.rpc.GerritJsonServletProvider;
import com.google.gwtjsonrpc.common.RemoteJsonService;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletModule;

public abstract class RpcServletModule
extends ServletModule {
    public static final String PREFIX = "/gerrit_ui/rpc/";
    private final String prefix;

    protected RpcServletModule(String pathPrefix) {
        this.prefix = pathPrefix;
    }

    protected void rpc(Class<? extends RemoteJsonService> clazz) {
        String name = clazz.getSimpleName();
        if (name.endsWith("Impl")) {
            name = name.substring(0, name.length() - 4);
        }
        this.rpc(name, clazz);
    }

    protected void rpc(String name, Class<? extends RemoteJsonService> clazz) {
        Key<GerritJsonServlet> srv = Key.get(GerritJsonServlet.class, UniqueAnnotations.create());
        GerritJsonServletProvider provider = new GerritJsonServletProvider(clazz);
        this.bind(clazz);
        this.serve(this.prefix + name, new String[0]).with(srv);
        this.bind(srv).toProvider(provider).in(Scopes.SINGLETON);
    }
}

