/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.account;

import com.google.gerrit.common.data.AccountProjectWatchInfo;
import com.google.gerrit.common.data.AccountService;
import com.google.gerrit.common.data.AgreementInfo;
import com.google.gerrit.common.errors.InvalidQueryException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.httpd.rpc.BaseServiceImplementation;
import com.google.gerrit.httpd.rpc.account.AgreementInfoFactory;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class AccountServiceImpl
extends BaseServiceImplementation
implements AccountService {
    private final Provider<IdentifiedUser> currentUser;
    private final AccountCache accountCache;
    private final ProjectControl.Factory projectControlFactory;
    private final AgreementInfoFactory.Factory agreementInfoFactory;
    private final ChangeQueryBuilder.Factory queryBuilder;

    @Inject
    AccountServiceImpl(Provider<ReviewDb> schema, Provider<IdentifiedUser> identifiedUser, AccountCache accountCache, ProjectControl.Factory projectControlFactory, AgreementInfoFactory.Factory agreementInfoFactory, ChangeQueryBuilder.Factory queryBuilder) {
        super(schema, identifiedUser);
        this.currentUser = identifiedUser;
        this.accountCache = accountCache;
        this.projectControlFactory = projectControlFactory;
        this.agreementInfoFactory = agreementInfoFactory;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public void myAccount(AsyncCallback<Account> callback) {
        this.run(callback, new BaseServiceImplementation.Action<Account>(){

            @Override
            public Account run(ReviewDb db) throws OrmException {
                return db.accounts().get(((IdentifiedUser)AccountServiceImpl.this.currentUser.get()).getAccountId());
            }
        });
    }

    @Override
    public void changePreferences(final AccountGeneralPreferences pref, AsyncCallback<VoidResult> callback) {
        this.run(callback, new BaseServiceImplementation.Action<VoidResult>(){

            @Override
            public VoidResult run(ReviewDb db) throws OrmException, BaseServiceImplementation.Failure {
                Account a = db.accounts().get(AccountServiceImpl.this.getAccountId());
                if (a == null) {
                    throw new BaseServiceImplementation.Failure(new NoSuchEntityException());
                }
                a.setGeneralPreferences(pref);
                db.accounts().update(Collections.singleton(a));
                AccountServiceImpl.this.accountCache.evict(a.getId());
                return VoidResult.INSTANCE;
            }
        });
    }

    @Override
    public void changeDiffPreferences(final AccountDiffPreference diffPref, AsyncCallback<VoidResult> callback) {
        this.run(callback, new BaseServiceImplementation.Action<VoidResult>(){

            @Override
            public VoidResult run(ReviewDb db) throws OrmException {
                if (!diffPref.getAccountId().equals(AccountServiceImpl.this.getAccountId())) {
                    throw new IllegalArgumentException("diffPref.getAccountId() " + diffPref.getAccountId() + " doesn't match" + " the accountId of the signed in user " + AccountServiceImpl.this.getAccountId());
                }
                db.accountDiffPreferences().upsert(Collections.singleton(diffPref));
                return VoidResult.INSTANCE;
            }
        });
    }

    @Override
    public void myProjectWatch(AsyncCallback<List<AccountProjectWatchInfo>> callback) {
        this.run(callback, new BaseServiceImplementation.Action<List<AccountProjectWatchInfo>>(){

            @Override
            public List<AccountProjectWatchInfo> run(ReviewDb db) throws OrmException {
                ArrayList<AccountProjectWatchInfo> r = new ArrayList<AccountProjectWatchInfo>();
                for (AccountProjectWatch w : db.accountProjectWatches().byAccount(AccountServiceImpl.this.getAccountId()).toList()) {
                    ProjectControl ctl;
                    try {
                        ctl = AccountServiceImpl.this.projectControlFactory.validateFor(w.getProjectNameKey());
                    }
                    catch (NoSuchProjectException e) {
                        db.accountProjectWatches().delete(Collections.singleton(w));
                        continue;
                    }
                    r.add(new AccountProjectWatchInfo(w, ctl.getProject()));
                }
                Collections.sort(r, new Comparator<AccountProjectWatchInfo>(){

                    @Override
                    public int compare(AccountProjectWatchInfo a, AccountProjectWatchInfo b) {
                        return a.getProject().getName().compareTo(b.getProject().getName());
                    }
                });
                return r;
            }
        });
    }

    @Override
    public void addProjectWatch(final String projectName, final String filter, AsyncCallback<AccountProjectWatchInfo> callback) {
        this.run(callback, new BaseServiceImplementation.Action<AccountProjectWatchInfo>(){

            @Override
            public AccountProjectWatchInfo run(ReviewDb db) throws OrmException, NoSuchProjectException, InvalidQueryException {
                Project.NameKey nameKey = new Project.NameKey(projectName);
                ProjectControl ctl = AccountServiceImpl.this.projectControlFactory.validateFor(nameKey);
                if (filter != null) {
                    try {
                        AccountServiceImpl.this.queryBuilder.create((CurrentUser)AccountServiceImpl.this.currentUser.get()).parse(filter);
                    }
                    catch (QueryParseException badFilter) {
                        throw new InvalidQueryException(badFilter.getMessage(), filter);
                    }
                }
                AccountProjectWatch watch = new AccountProjectWatch(new AccountProjectWatch.Key(((IdentifiedUser)ctl.getCurrentUser()).getAccountId(), nameKey, filter));
                try {
                    db.accountProjectWatches().insert(Collections.singleton(watch));
                }
                catch (OrmDuplicateKeyException alreadyHave) {
                    watch = db.accountProjectWatches().get(watch.getKey());
                }
                return new AccountProjectWatchInfo(watch, ctl.getProject());
            }
        });
    }

    @Override
    public void updateProjectWatch(final AccountProjectWatch watch, AsyncCallback<VoidResult> callback) {
        if (!this.getAccountId().equals(watch.getAccountId())) {
            callback.onFailure(new NoSuchEntityException());
            return;
        }
        this.run(callback, new BaseServiceImplementation.Action<VoidResult>(){

            @Override
            public VoidResult run(ReviewDb db) throws OrmException {
                db.accountProjectWatches().update(Collections.singleton(watch));
                return VoidResult.INSTANCE;
            }
        });
    }

    @Override
    public void deleteProjectWatches(final Set<AccountProjectWatch.Key> keys, AsyncCallback<VoidResult> callback) {
        this.run(callback, new BaseServiceImplementation.Action<VoidResult>(){

            @Override
            public VoidResult run(ReviewDb db) throws OrmException, BaseServiceImplementation.Failure {
                Account.Id me = AccountServiceImpl.this.getAccountId();
                for (AccountProjectWatch.Key keyId : keys) {
                    if (me.equals(keyId.getParentKey())) continue;
                    throw new BaseServiceImplementation.Failure(new NoSuchEntityException());
                }
                db.accountProjectWatches().deleteKeys(keys);
                return VoidResult.INSTANCE;
            }
        });
    }

    @Override
    public void myAgreements(AsyncCallback<AgreementInfo> callback) {
        this.agreementInfoFactory.create().to(callback);
    }
}

