/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.AgreementInfo;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AgreementInfoFactory
extends Handler<AgreementInfo> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IdentifiedUser user;
    private final ProjectCache projectCache;
    private AgreementInfo info;

    @Inject
    AgreementInfoFactory(IdentifiedUser user, ProjectCache projectCache) {
        this.user = user;
        this.projectCache = projectCache;
    }

    @Override
    public AgreementInfo call() throws Exception {
        ArrayList<String> accepted = Lists.newArrayList();
        HashMap<String, ContributorAgreement> agreements = Maps.newHashMap();
        Collection<ContributorAgreement> cas = this.projectCache.getAllProjects().getConfig().getContributorAgreements();
        for (ContributorAgreement ca : cas) {
            agreements.put(ca.getName(), ca.forUi());
            ArrayList<AccountGroup.UUID> groupIds = Lists.newArrayList();
            for (PermissionRule rule : ca.getAccepted()) {
                if (rule.getAction() != PermissionRule.Action.ALLOW || rule.getGroup() == null) continue;
                if (rule.getGroup().getUUID() == null) {
                    this.log.warn("group \"" + rule.getGroup().getName() + "\" does not " + " exist, referenced in CLA \"" + ca.getName() + "\"");
                    continue;
                }
                groupIds.add(new AccountGroup.UUID(rule.getGroup().getUUID().get()));
            }
            if (!this.user.getEffectiveGroups().containsAnyOf(groupIds)) continue;
            accepted.add(ca.getName());
        }
        this.info = new AgreementInfo();
        this.info.setAccepted(accepted);
        this.info.setAgreements(agreements);
        return this.info;
    }

    static interface Factory {
        public AgreementInfoFactory create();
    }
}

