/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.account;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;

class ExternalIdDetailFactory
extends Handler<List<AccountExternalId>> {
    private final ReviewDb db;
    private final IdentifiedUser user;
    private final AuthConfig authConfig;
    private final DynamicItem<WebSession> session;

    @Inject
    ExternalIdDetailFactory(ReviewDb db, IdentifiedUser user, AuthConfig authConfig, DynamicItem<WebSession> session) {
        this.db = db;
        this.user = user;
        this.authConfig = authConfig;
        this.session = session;
    }

    @Override
    public List<AccountExternalId> call() throws OrmException {
        AccountExternalId.Key last = this.session.get().getLastLoginExternalId();
        List<AccountExternalId> ids = this.db.accountExternalIds().byAccount(this.user.getAccountId()).toList();
        for (AccountExternalId e : ids) {
            e.setTrusted(this.authConfig.isIdentityTrustable(Collections.singleton(e)));
            if (e.isScheme("username:")) {
                e.setCanDelete(false);
                continue;
            }
            e.setCanDelete(last != null && !last.equals(e.getKey()));
        }
        return ids;
    }

    static interface Factory {
        public ExternalIdDetailFactory create();
    }
}

