/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.change;

import com.google.gerrit.server.query.change.QueryProcessor;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class DeprecatedChangeQueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Provider<QueryProcessor> processor;

    @Inject
    DeprecatedChangeQueryServlet(Provider<QueryProcessor> processor) {
        this.processor = processor;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        rsp.setContentType("text/json");
        rsp.setCharacterEncoding("UTF-8");
        QueryProcessor p = this.processor.get();
        QueryProcessor.OutputFormat format = QueryProcessor.OutputFormat.JSON;
        try {
            format = QueryProcessor.OutputFormat.valueOf(DeprecatedChangeQueryServlet.get(req, "format", format.toString()));
        }
        catch (IllegalArgumentException err) {
            DeprecatedChangeQueryServlet.error(rsp, "invalid format");
            return;
        }
        switch (format) {
            case JSON: {
                rsp.setContentType("text/json");
                rsp.setCharacterEncoding("UTF-8");
                break;
            }
            case TEXT: {
                rsp.setContentType("text/plain");
                rsp.setCharacterEncoding("UTF-8");
                break;
            }
            default: {
                DeprecatedChangeQueryServlet.error(rsp, "invalid format");
                return;
            }
        }
        p.setIncludeComments(DeprecatedChangeQueryServlet.get(req, "comments", false));
        p.setIncludeCurrentPatchSet(DeprecatedChangeQueryServlet.get(req, "current-patch-set", false));
        p.setIncludePatchSets(DeprecatedChangeQueryServlet.get(req, "patch-sets", false));
        p.setIncludeApprovals(DeprecatedChangeQueryServlet.get(req, "all-approvals", false));
        p.setIncludeFiles(DeprecatedChangeQueryServlet.get(req, "files", false));
        p.setOutput(rsp.getOutputStream(), format);
        p.query(DeprecatedChangeQueryServlet.get(req, "q", "status:open"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void error(HttpServletResponse rsp, String message) throws IOException {
        ErrorMessage em = new ErrorMessage();
        em.message = message;
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(new Gson().toJson(em).getBytes("UTF-8"));
            out.write(10);
            out.flush();
        }
    }

    private static String get(HttpServletRequest req, String name, String val) {
        String v = req.getParameter(name);
        if (v == null || v.isEmpty()) {
            return val;
        }
        return v;
    }

    private static boolean get(HttpServletRequest req, String name, boolean val) {
        String v = req.getParameter(name);
        if (v == null || v.isEmpty()) {
            return val;
        }
        return "true".equalsIgnoreCase(v);
    }

    public static class ErrorMessage {
        public final String type = "error";
        public String message;
    }
}

