/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.ProjectAccess;
import com.google.gerrit.common.data.ProjectAdminService;
import com.google.gerrit.httpd.rpc.project.ChangeProjectAccess;
import com.google.gerrit.httpd.rpc.project.ProjectAccessFactory;
import com.google.gerrit.httpd.rpc.project.ReviewProjectAccess;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;

class ProjectAdminServiceImpl
implements ProjectAdminService {
    private final ChangeProjectAccess.Factory changeProjectAccessFactory;
    private final ReviewProjectAccess.Factory reviewProjectAccessFactory;
    private final ProjectAccessFactory.Factory projectAccessFactory;

    @Inject
    ProjectAdminServiceImpl(ChangeProjectAccess.Factory changeProjectAccessFactory, ReviewProjectAccess.Factory reviewProjectAccessFactory, ProjectAccessFactory.Factory projectAccessFactory) {
        this.changeProjectAccessFactory = changeProjectAccessFactory;
        this.reviewProjectAccessFactory = reviewProjectAccessFactory;
        this.projectAccessFactory = projectAccessFactory;
    }

    @Override
    public void projectAccess(Project.NameKey projectName, AsyncCallback<ProjectAccess> callback) {
        this.projectAccessFactory.create(projectName).to(callback);
    }

    private static ObjectId getBase(String baseRevision) {
        if (baseRevision != null && !baseRevision.isEmpty()) {
            return ObjectId.fromString(baseRevision);
        }
        return null;
    }

    @Override
    public void changeProjectAccess(Project.NameKey projectName, String baseRevision, String msg, List<AccessSection> sections, Project.NameKey parentProjectName, AsyncCallback<ProjectAccess> cb) {
        this.changeProjectAccessFactory.create(projectName, ProjectAdminServiceImpl.getBase(baseRevision), sections, parentProjectName, msg).to(cb);
    }

    @Override
    public void reviewProjectAccess(Project.NameKey projectName, String baseRevision, String msg, List<AccessSection> sections, Project.NameKey parentProjectName, AsyncCallback<Change.Id> cb) {
        this.reviewProjectAccessFactory.create(projectName, ProjectAdminServiceImpl.getBase(baseRevision), sections, parentProjectName, msg).to(cb);
    }
}

