/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.prettify.common;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.diff.Edit;

public class EditList {
    private final List<Edit> edits;
    private final int context;
    private final int aSize;
    private final int bSize;

    public EditList(List<Edit> edits, int contextLines, int aSize, int bSize) {
        this.edits = edits;
        this.context = contextLines;
        this.aSize = aSize;
        this.bSize = bSize;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public Iterable<Hunk> getHunks() {
        return new Iterable<Hunk>(){

            @Override
            public Iterator<Hunk> iterator() {
                return new Iterator<Hunk>(){
                    private int curIdx;

                    @Override
                    public boolean hasNext() {
                        return this.curIdx < EditList.this.edits.size();
                    }

                    @Override
                    public Hunk next() {
                        int c = this.curIdx;
                        int e = EditList.this.findCombinedEnd(c);
                        this.curIdx = e + 1;
                        return new Hunk(c, e);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private int findCombinedEnd(int i) {
        int end;
        for (end = i + 1; end < this.edits.size() && (this.combineA(end) || this.combineB(end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(int i) {
        Edit s = this.edits.get(i);
        Edit e = this.edits.get(i - 1);
        return s.getBeginA() - e.getEndA() <= 2 * this.context + 1;
    }

    private boolean combineB(int i) {
        int e;
        int s = this.edits.get(i).getBeginB();
        return s - (e = this.edits.get(i - 1).getEndB()) <= 2 * this.context + 1;
    }

    public class Hunk {
        private int curIdx;
        private Edit curEdit;
        private final int endIdx;
        private final Edit endEdit;
        private int aCur;
        private int bCur;
        private final int aEnd;
        private final int bEnd;

        private Hunk(int ci, int ei) {
            this.curIdx = ci;
            this.endIdx = ei;
            this.curEdit = (Edit)EditList.this.edits.get(this.curIdx);
            this.endEdit = (Edit)EditList.this.edits.get(this.endIdx);
            this.aCur = Math.max(0, this.curEdit.getBeginA() - EditList.this.context);
            this.bCur = Math.max(0, this.curEdit.getBeginB() - EditList.this.context);
            this.aEnd = Math.min(EditList.this.aSize, this.endEdit.getEndA() + EditList.this.context);
            this.bEnd = Math.min(EditList.this.bSize, this.endEdit.getEndB() + EditList.this.context);
        }

        public int getCurA() {
            return this.aCur;
        }

        public int getCurB() {
            return this.bCur;
        }

        public Edit getCurEdit() {
            return this.curEdit;
        }

        public int getEndA() {
            return this.aEnd;
        }

        public int getEndB() {
            return this.bEnd;
        }

        public void incA() {
            ++this.aCur;
        }

        public void incB() {
            ++this.bCur;
        }

        public void incBoth() {
            this.incA();
            this.incB();
        }

        public boolean isStartOfFile() {
            return this.aCur == 0 && this.bCur == 0;
        }

        public boolean isContextLine() {
            return !this.isModifiedLine();
        }

        public boolean isDeletedA() {
            return this.curEdit.getBeginA() <= this.aCur && this.aCur < this.curEdit.getEndA();
        }

        public boolean isInsertedB() {
            return this.curEdit.getBeginB() <= this.bCur && this.bCur < this.curEdit.getEndB();
        }

        public boolean isModifiedLine() {
            return this.isDeletedA() || this.isInsertedB();
        }

        public boolean next() {
            if (!this.in(this.curEdit) && this.curIdx < this.endIdx) {
                this.curEdit = (Edit)EditList.this.edits.get(++this.curIdx);
            }
            return this.aCur < this.aEnd || this.bCur < this.bEnd;
        }

        private boolean in(Edit edit) {
            return this.aCur < edit.getEndA() || this.bCur < edit.getEndB();
        }
    }
}

