/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.CodedEnum;
import com.google.gwtorm.client.Column;

public class AccountDiffPreference {
    public static final short DEFAULT_CONTEXT = 10;
    public static final short WHOLE_FILE_CONTEXT = -1;
    public static final short[] CONTEXT_CHOICES = new short[]{3, 10, 25, 50, 75, 100, -1};
    @Column(id=1, name="--NONE--")
    protected Account.Id accountId;
    @Column(id=2)
    protected char ignoreWhitespace;
    @Column(id=3)
    protected int tabSize;
    @Column(id=4)
    protected int lineLength;
    @Column(id=5)
    protected boolean syntaxHighlighting;
    @Column(id=6)
    protected boolean showWhitespaceErrors;
    @Column(id=7)
    protected boolean intralineDifference;
    @Column(id=8)
    protected boolean showTabs;
    @Column(id=9)
    protected short context;
    @Column(id=10)
    protected boolean skipDeleted;
    @Column(id=11)
    protected boolean skipUncommented;
    @Column(id=12)
    protected boolean expandAllComments;
    @Column(id=13)
    protected boolean retainHeader;
    @Column(id=14)
    protected boolean manualReview;
    @Column(id=15)
    protected boolean showLineEndings;
    @Column(id=16)
    protected boolean hideTopMenu;
    @Column(id=17)
    protected boolean hideLineNumbers;
    @Column(id=18)
    protected boolean renderEntireFile;
    @Column(id=19, length=20, notNull=false)
    protected String theme;
    @Column(id=20)
    protected boolean hideEmptyPane;

    public static AccountDiffPreference createDefault(Account.Id accountId) {
        AccountDiffPreference p = new AccountDiffPreference(accountId);
        p.setIgnoreWhitespace(Whitespace.IGNORE_NONE);
        p.setTheme(Theme.DEFAULT);
        p.setTabSize(8);
        p.setLineLength(100);
        p.setSyntaxHighlighting(true);
        p.setShowWhitespaceErrors(true);
        p.setShowLineEndings(true);
        p.setIntralineDifference(true);
        p.setShowTabs(true);
        p.setContext((short)10);
        p.setManualReview(false);
        p.setHideEmptyPane(false);
        return p;
    }

    protected AccountDiffPreference() {
    }

    public AccountDiffPreference(Account.Id accountId) {
        this.accountId = accountId;
    }

    public AccountDiffPreference(AccountDiffPreference p) {
        this.accountId = p.accountId;
        this.ignoreWhitespace = p.ignoreWhitespace;
        this.tabSize = p.tabSize;
        this.lineLength = p.lineLength;
        this.syntaxHighlighting = p.syntaxHighlighting;
        this.showWhitespaceErrors = p.showWhitespaceErrors;
        this.showLineEndings = p.showLineEndings;
        this.intralineDifference = p.intralineDifference;
        this.showTabs = p.showTabs;
        this.skipDeleted = p.skipDeleted;
        this.skipUncommented = p.skipUncommented;
        this.expandAllComments = p.expandAllComments;
        this.context = p.context;
        this.retainHeader = p.retainHeader;
        this.manualReview = p.manualReview;
        this.hideTopMenu = p.hideTopMenu;
        this.hideLineNumbers = p.hideLineNumbers;
        this.renderEntireFile = p.renderEntireFile;
        this.hideEmptyPane = p.hideEmptyPane;
    }

    public Account.Id getAccountId() {
        return this.accountId;
    }

    public Whitespace getIgnoreWhitespace() {
        return Whitespace.forCode(this.ignoreWhitespace);
    }

    public void setIgnoreWhitespace(Whitespace ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace.getCode();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public boolean isSyntaxHighlighting() {
        return this.syntaxHighlighting;
    }

    public void setSyntaxHighlighting(boolean syntaxHighlighting) {
        this.syntaxHighlighting = syntaxHighlighting;
    }

    public boolean isShowWhitespaceErrors() {
        return this.showWhitespaceErrors;
    }

    public void setShowWhitespaceErrors(boolean showWhitespaceErrors) {
        this.showWhitespaceErrors = showWhitespaceErrors;
    }

    public boolean isShowLineEndings() {
        return this.showLineEndings;
    }

    public void setShowLineEndings(boolean showLineEndings) {
        this.showLineEndings = showLineEndings;
    }

    public boolean isIntralineDifference() {
        return this.intralineDifference;
    }

    public void setIntralineDifference(boolean intralineDifference) {
        this.intralineDifference = intralineDifference;
    }

    public boolean isShowTabs() {
        return this.showTabs;
    }

    public void setShowTabs(boolean showTabs) {
        this.showTabs = showTabs;
    }

    public short getContext() {
        return this.context;
    }

    public void setContext(short context) {
        assert (0 <= context || context == -1);
        this.context = context;
    }

    public boolean isSkipDeleted() {
        return this.skipDeleted;
    }

    public void setSkipDeleted(boolean skip) {
        this.skipDeleted = skip;
    }

    public boolean isSkipUncommented() {
        return this.skipUncommented;
    }

    public void setSkipUncommented(boolean skip) {
        this.skipUncommented = skip;
    }

    public boolean isExpandAllComments() {
        return this.expandAllComments;
    }

    public void setExpandAllComments(boolean expand) {
        this.expandAllComments = expand;
    }

    public boolean isRetainHeader() {
        return this.retainHeader;
    }

    public void setRetainHeader(boolean retain) {
        this.retainHeader = retain;
    }

    public boolean isManualReview() {
        return this.manualReview;
    }

    public void setManualReview(boolean manual) {
        this.manualReview = manual;
    }

    public boolean isHideTopMenu() {
        return this.hideTopMenu;
    }

    public void setHideTopMenu(boolean hide) {
        this.hideTopMenu = hide;
    }

    public boolean isHideLineNumbers() {
        return this.hideLineNumbers;
    }

    public void setHideLineNumbers(boolean hide) {
        this.hideLineNumbers = hide;
    }

    public boolean isRenderEntireFile() {
        return this.renderEntireFile;
    }

    public void setRenderEntireFile(boolean render) {
        this.renderEntireFile = render;
    }

    public Theme getTheme() {
        return this.theme != null ? Theme.valueOf(this.theme) : null;
    }

    public void setTheme(Theme theme) {
        this.theme = theme != null ? theme.name() : null;
    }

    public boolean isHideEmptyPane() {
        return this.hideEmptyPane;
    }

    public void setHideEmptyPane(boolean hideEmptyPane) {
        this.hideEmptyPane = hideEmptyPane;
    }

    public static enum Theme {
        DEFAULT,
        ECLIPSE,
        ELEGANT,
        NEAT,
        MIDNIGHT,
        NIGHT,
        TWILIGHT;


        public boolean isDark() {
            switch (this) {
                case MIDNIGHT: 
                case NIGHT: 
                case TWILIGHT: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Whitespace implements CodedEnum
    {
        IGNORE_NONE('N'),
        IGNORE_SPACE_AT_EOL('E'),
        IGNORE_SPACE_CHANGE('S'),
        IGNORE_ALL_SPACE('A');

        private final char code;

        private Whitespace(char c) {
            this.code = c;
        }

        @Override
        public char getCode() {
            return this.code;
        }

        public static Whitespace forCode(char c) {
            for (Whitespace s : Whitespace.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }
}

