/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;

public final class AccountExternalId {
    public static final String SCHEME_GERRIT = "gerrit:";
    public static final String SCHEME_UUID = "uuid:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_USERNAME = "username:";
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Account.Id accountId;
    @Column(id=3, notNull=false)
    protected String emailAddress;
    @Column(id=4, notNull=false)
    protected String password;
    protected boolean trusted;
    protected boolean canDelete;

    protected AccountExternalId() {
    }

    public AccountExternalId(Account.Id who, Key k) {
        this.accountId = who;
        this.key = k;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAccountId() {
        return this.accountId;
    }

    public String getExternalId() {
        return this.key.externalId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String e) {
        this.emailAddress = e;
    }

    public boolean isScheme(String scheme) {
        String id = this.getExternalId();
        return id != null && id.startsWith(scheme);
    }

    public String getSchemeRest() {
        String id = this.getExternalId();
        int c = id.indexOf(58);
        return 0 < c ? id.substring(c + 1) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean t) {
        this.trusted = t;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean t) {
        this.canDelete = t;
    }

    public static class Key
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String externalId;

        protected Key() {
        }

        public Key(String scheme, String identity) {
            if (!scheme.endsWith(":")) {
                scheme = scheme + ":";
            }
            this.externalId = scheme + identity;
        }

        public Key(String e) {
            this.externalId = e;
        }

        @Override
        public String get() {
            return this.externalId;
        }

        @Override
        protected void set(String newValue) {
            this.externalId = newValue;
        }
    }
}

