/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gwtorm.client.Column;

public final class AccountGeneralPreferences {
    public static final short DEFAULT_PAGESIZE = 25;
    public static final short[] PAGESIZE_CHOICES = new short[]{10, 25, 50, 100};
    @Column(id=2)
    protected short maximumPageSize;
    @Column(id=3)
    protected boolean showSiteHeader;
    @Column(id=4)
    protected boolean useFlashClipboard;
    @Column(id=5, length=20, notNull=false)
    protected String downloadUrl;
    @Column(id=6, length=20, notNull=false)
    protected String downloadCommand;
    @Column(id=7)
    protected boolean copySelfOnEmail;
    @Column(id=8, length=10, notNull=false)
    protected String dateFormat;
    @Column(id=9, length=10, notNull=false)
    protected String timeFormat;
    @Column(id=10)
    protected boolean reversePatchSetOrder;
    @Column(id=12)
    protected boolean relativeDateInChangeTable;
    @Column(id=13, length=20, notNull=false)
    protected String commentVisibilityStrategy;
    @Column(id=14, length=20, notNull=false)
    protected String diffView;
    @Column(id=15, length=20, notNull=false)
    protected String changeScreen;
    @Column(id=16)
    protected boolean sizeBarInChangeTable;
    @Column(id=17)
    protected boolean legacycidInChangeTable;
    @Column(id=18, length=20, notNull=false)
    protected String reviewCategoryStrategy;

    public static AccountGeneralPreferences createDefault() {
        AccountGeneralPreferences p = new AccountGeneralPreferences();
        p.resetToDefaults();
        return p;
    }

    public short getMaximumPageSize() {
        return this.maximumPageSize;
    }

    public void setMaximumPageSize(short s) {
        this.maximumPageSize = s;
    }

    public boolean isShowSiteHeader() {
        return this.showSiteHeader;
    }

    public void setShowSiteHeader(boolean b) {
        this.showSiteHeader = b;
    }

    public boolean isUseFlashClipboard() {
        return this.useFlashClipboard;
    }

    public void setUseFlashClipboard(boolean b) {
        this.useFlashClipboard = b;
    }

    public DownloadScheme getDownloadUrl() {
        if (this.downloadUrl == null) {
            return null;
        }
        return DownloadScheme.valueOf(this.downloadUrl);
    }

    public void setDownloadUrl(DownloadScheme url) {
        this.downloadUrl = url != null ? url.name() : null;
    }

    public DownloadCommand getDownloadCommand() {
        if (this.downloadCommand == null) {
            return null;
        }
        return DownloadCommand.valueOf(this.downloadCommand);
    }

    public void setDownloadCommand(DownloadCommand cmd) {
        this.downloadCommand = cmd != null ? cmd.name() : null;
    }

    public boolean isCopySelfOnEmails() {
        return this.copySelfOnEmail;
    }

    public void setCopySelfOnEmails(boolean includeSelfOnEmail) {
        this.copySelfOnEmail = includeSelfOnEmail;
    }

    public boolean isReversePatchSetOrder() {
        return this.reversePatchSetOrder;
    }

    public void setReversePatchSetOrder(boolean reversePatchSetOrder) {
        this.reversePatchSetOrder = reversePatchSetOrder;
    }

    public boolean isShowInfoInReviewCategory() {
        return this.getReviewCategoryStrategy() != ReviewCategoryStrategy.NONE;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            return DateFormat.STD;
        }
        return DateFormat.valueOf(this.dateFormat);
    }

    public void setDateFormat(DateFormat fmt) {
        this.dateFormat = fmt.name();
    }

    public TimeFormat getTimeFormat() {
        if (this.timeFormat == null) {
            return TimeFormat.HHMM_12;
        }
        return TimeFormat.valueOf(this.timeFormat);
    }

    public void setTimeFormat(TimeFormat fmt) {
        this.timeFormat = fmt.name();
    }

    public boolean isRelativeDateInChangeTable() {
        return this.relativeDateInChangeTable;
    }

    public void setRelativeDateInChangeTable(boolean relativeDateInChangeTable) {
        this.relativeDateInChangeTable = relativeDateInChangeTable;
    }

    public ReviewCategoryStrategy getReviewCategoryStrategy() {
        if (this.reviewCategoryStrategy == null) {
            return ReviewCategoryStrategy.NONE;
        }
        return ReviewCategoryStrategy.valueOf(this.reviewCategoryStrategy);
    }

    public void setReviewCategoryStrategy(ReviewCategoryStrategy strategy) {
        this.reviewCategoryStrategy = strategy.name();
    }

    public CommentVisibilityStrategy getCommentVisibilityStrategy() {
        if (this.commentVisibilityStrategy == null) {
            return CommentVisibilityStrategy.EXPAND_RECENT;
        }
        return CommentVisibilityStrategy.valueOf(this.commentVisibilityStrategy);
    }

    public void setCommentVisibilityStrategy(CommentVisibilityStrategy strategy) {
        this.commentVisibilityStrategy = strategy.name();
    }

    public DiffView getDiffView() {
        if (this.diffView == null) {
            return DiffView.SIDE_BY_SIDE;
        }
        return DiffView.valueOf(this.diffView);
    }

    public void setDiffView(DiffView diffView) {
        this.diffView = diffView.name();
    }

    public ChangeScreen getChangeScreen() {
        return this.changeScreen != null ? ChangeScreen.valueOf(this.changeScreen) : null;
    }

    public void setChangeScreen(ChangeScreen ui) {
        this.changeScreen = ui != null ? ui.name() : null;
    }

    public boolean isSizeBarInChangeTable() {
        return this.sizeBarInChangeTable;
    }

    public void setSizeBarInChangeTable(boolean sizeBarInChangeTable) {
        this.sizeBarInChangeTable = sizeBarInChangeTable;
    }

    public boolean isLegacycidInChangeTable() {
        return this.legacycidInChangeTable;
    }

    public void setLegacycidInChangeTable(boolean legacycidInChangeTable) {
        this.legacycidInChangeTable = legacycidInChangeTable;
    }

    public void resetToDefaults() {
        this.maximumPageSize = (short)25;
        this.showSiteHeader = true;
        this.useFlashClipboard = true;
        this.copySelfOnEmail = false;
        this.reversePatchSetOrder = false;
        this.reviewCategoryStrategy = null;
        this.downloadUrl = null;
        this.downloadCommand = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.relativeDateInChangeTable = false;
        this.commentVisibilityStrategy = null;
        this.diffView = null;
        this.changeScreen = null;
        this.sizeBarInChangeTable = true;
        this.legacycidInChangeTable = false;
    }

    public static enum TimeFormat {
        HHMM_12("h:mm a"),
        HHMM_24("HH:mm");

        private final String format;

        private TimeFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static enum ChangeScreen {
        OLD_UI,
        CHANGE_SCREEN2;

    }

    public static enum DiffView {
        SIDE_BY_SIDE,
        UNIFIED_DIFF;

    }

    public static enum ReviewCategoryStrategy {
        NONE,
        NAME,
        EMAIL,
        USERNAME,
        ABBREV;

    }

    public static enum CommentVisibilityStrategy {
        COLLAPSE_ALL,
        EXPAND_MOST_RECENT,
        EXPAND_RECENT,
        EXPAND_ALL;

    }

    public static enum DateFormat {
        STD("MMM d", "MMM d, yyyy"),
        US("MM/dd", "MM/dd/yy"),
        ISO("MM-dd", "yyyy-MM-dd"),
        EURO("d. MMM", "dd.MM.yyyy"),
        UK("dd/MM", "dd/MM/yyyy");

        private final String shortFormat;
        private final String longFormat;

        private DateFormat(String shortFormat, String longFormat) {
            this.shortFormat = shortFormat;
            this.longFormat = longFormat;
        }

        public String getShortFormat() {
            return this.shortFormat;
        }

        public String getLongFormat() {
            return this.longFormat;
        }
    }

    public static enum DownloadCommand {
        REPO_DOWNLOAD,
        PULL,
        CHECKOUT,
        CHERRY_PICK,
        FORMAT_PATCH,
        DEFAULT_DOWNLOADS;

    }

    public static enum DownloadScheme {
        ANON_GIT,
        ANON_HTTP,
        HTTP,
        SSH,
        REPO_DOWNLOAD,
        DEFAULT_DOWNLOADS;

    }
}

