/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;

public final class AccountSshKey {
    @Column(id=1, name="--NONE--")
    protected Id id;
    @Column(id=2, length=0x7FFFFFFF)
    protected String sshPublicKey;
    @Column(id=3)
    protected boolean valid;

    protected AccountSshKey() {
    }

    public AccountSshKey(Id i, String pub) {
        this.id = i;
        this.sshPublicKey = pub;
        this.valid = true;
    }

    public Account.Id getAccount() {
        return this.id.accountId;
    }

    public Id getKey() {
        return this.id;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public String getAlgorithm() {
        String s = this.getSshPublicKey();
        if (s == null || s.length() == 0) {
            return "none";
        }
        String[] parts = s.split(" ");
        if (parts.length < 1) {
            return "none";
        }
        return parts[0];
    }

    public String getEncodedKey() {
        String s = this.getSshPublicKey();
        if (s == null || s.length() == 0) {
            return null;
        }
        String[] parts = s.split(" ");
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    public String getComment() {
        String s = this.getSshPublicKey();
        if (s == null || s.length() == 0) {
            return "";
        }
        String[] parts = s.split(" ", 3);
        if (parts.length < 3) {
            return "";
        }
        return parts[2];
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setInvalid() {
        this.valid = false;
    }

    public static class Id
    extends IntKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Account.Id accountId;
        @Column(id=2)
        protected int seq;

        protected Id() {
            this.accountId = new Account.Id();
        }

        public Id(Account.Id a, int s) {
            this.accountId = a;
            this.seq = s;
        }

        @Override
        public Account.Id getParentKey() {
            return this.accountId;
        }

        @Override
        public int get() {
            return this.seq;
        }

        @Override
        protected void set(int newValue) {
            this.seq = newValue;
        }
    }
}

