/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.gerrit.common.Version;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.util.TimeUtil;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.googlecode.prolog_cafe.compiler.CompileException;
import com.googlecode.prolog_cafe.compiler.Compiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class PrologCompiler
implements Callable<Status> {
    private final File ruleDir;
    private final Repository git;

    @Inject
    PrologCompiler(@GerritServerConfig Config config, SitePaths site, @Assisted Repository gitRepository) {
        File cacheDir = site.resolve(config.getString("cache", null, "directory"));
        this.ruleDir = cacheDir != null ? new File(cacheDir, "rules") : null;
        this.git = gitRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status call() throws IOException, CompileException {
        ObjectId metaConfig = this.git.resolve("refs/meta/config");
        if (metaConfig == null) {
            return Status.NO_RULES;
        }
        ObjectId rulesId = this.git.resolve(metaConfig.name() + ":rules.pl");
        if (rulesId == null) {
            return Status.NO_RULES;
        }
        if (this.ruleDir == null) {
            throw new CompileException("Caching not enabled");
        }
        if (!this.ruleDir.isDirectory() && !this.ruleDir.mkdir()) {
            throw new IOException("Cannot create " + this.ruleDir);
        }
        File tempDir = File.createTempFile("GerritCodeReview_", ".rulec");
        if (!tempDir.delete() || !tempDir.mkdir()) {
            throw new IOException("Cannot create " + tempDir);
        }
        try {
            tempDir.setReadable(true, true);
            tempDir.setWritable(true, true);
            tempDir.setExecutable(true, true);
            this.compileProlog(rulesId, tempDir);
            this.compileJava(tempDir);
            File jarFile = new File(this.ruleDir, "rules-" + rulesId.getName() + ".jar");
            List<String> classFiles = this.getRelativePaths(tempDir, ".class");
            this.createJar(jarFile, classFiles, tempDir, metaConfig, rulesId);
            Status status = Status.COMPILED;
            return status;
        }
        finally {
            this.deleteAllFiles(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileProlog(ObjectId prolog, File tempDir) throws IOException, CompileException {
        File tempRules = this.copyToTempFile(prolog, tempDir);
        try {
            Compiler comp = new Compiler();
            comp.prologToJavaSource(tempRules.getPath(), tempDir.getPath());
        }
        finally {
            tempRules.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToTempFile(ObjectId blobId, File tempDir) throws IOException, FileNotFoundException, MissingObjectException {
        File tmp = File.createTempFile("rules", ".pl", tempDir);
        try (FileOutputStream out = new FileOutputStream(tmp);){
            this.git.open(blobId).copyTo(out);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileJava(File tempDir) throws IOException, CompileException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK required (running inside of JRE)");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(this.getAllFiles(tempDir, ".java"));
            ArrayList<String> options = new ArrayList<String>();
            String classpath = this.getMyClasspath();
            if (classpath != null) {
                options.add("-classpath");
                options.add(classpath);
            }
            options.add("-d");
            options.add(tempDir.getPath());
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            if (!task.call().booleanValue()) {
                Locale myLocale = Locale.getDefault();
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot compile to Java bytecode:");
                for (Diagnostic err : diagnostics.getDiagnostics()) {
                    msg.append('\n');
                    msg.append((Object)err.getKind());
                    msg.append(": ");
                    if (err.getSource() != null) {
                        msg.append(((JavaFileObject)err.getSource()).getName());
                    }
                    msg.append(':');
                    msg.append(err.getLineNumber());
                    msg.append(": ");
                    msg.append(err.getMessage(myLocale));
                }
                throw new CompileException(msg.toString());
            }
        }
    }

    private String getMyClasspath() {
        StringBuilder cp = new StringBuilder();
        this.appendClasspath(cp, this.getClass().getClassLoader());
        return 0 < cp.length() ? cp.toString() : null;
    }

    private void appendClasspath(StringBuilder cp, ClassLoader classLoader) {
        if (classLoader.getParent() != null) {
            this.appendClasspath(cp, classLoader.getParent());
        }
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                if (!"file".equals(url.getProtocol())) continue;
                if (0 < cp.length()) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(url.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(File archiveFile, List<String> toBeJared, File tempDir, ObjectId metaConfig, ObjectId rulesId) throws IOException {
        long now = TimeUtil.nowMs();
        File tmpjar = File.createTempFile(".rulec_", ".jar", archiveFile.getParentFile());
        try {
            Manifest mf = new Manifest();
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mf.getMainAttributes().putValue("Built-by", "Gerrit Code Review " + Version.getVersion());
            if (this.git.getDirectory() != null) {
                mf.getMainAttributes().putValue("Source-Repository", this.git.getDirectory().getPath());
            }
            mf.getMainAttributes().putValue("Source-Commit", metaConfig.name());
            mf.getMainAttributes().putValue("Source-Blob", rulesId.name());
            try (FileOutputStream stream = new FileOutputStream(tmpjar);
                 JarOutputStream out = new JarOutputStream((OutputStream)stream, mf);){
                byte[] buffer = new byte[10240];
                for (String path : toBeJared) {
                    JarEntry jarAdd = new JarEntry(path);
                    File f = new File(tempDir, path);
                    jarAdd.setTime(now);
                    out.putNextEntry(jarAdd);
                    if (f.isFile()) {
                        try (FileInputStream in = new FileInputStream(f);){
                            int nRead;
                            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                                out.write(buffer, 0, nRead);
                            }
                        }
                    }
                    out.closeEntry();
                }
            }
            if (!tmpjar.renameTo(archiveFile)) {
                throw new IOException("Cannot replace " + archiveFile);
            }
        }
        finally {
            tmpjar.delete();
        }
    }

    private List<File> getAllFiles(File dir, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(dir, extension, fileList);
        return fileList;
    }

    private void getAllFiles(File dir, String extension, List<File> fileList) {
        for (File f : dir.listFiles()) {
            if (f.getName().endsWith(extension)) {
                fileList.add(f);
            }
            if (!f.isDirectory()) continue;
            this.getAllFiles(f, extension, fileList);
        }
    }

    private List<String> getRelativePaths(File dir, String extension) {
        ArrayList<String> pathList = new ArrayList<String>();
        this.getRelativePaths(dir, extension, "", pathList);
        return pathList;
    }

    private void getRelativePaths(File dir, String extension, String path, List<String> pathList) {
        for (File f : dir.listFiles()) {
            if (f.getName().endsWith(extension)) {
                pathList.add(path + f.getName());
            }
            if (!f.isDirectory()) continue;
            this.getRelativePaths(f, extension, path + f.getName() + "/", pathList);
        }
    }

    private void deleteAllFiles(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteAllFiles(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    public static enum Status {
        NO_RULES,
        COMPILED;

    }

    public static interface Factory {
        public PrologCompiler create(Repository var1);
    }
}

