/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.StoredValue;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SystemException;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public final class StoredValues {
    public static final StoredValue<ReviewDb> REVIEW_DB = StoredValue.create(ReviewDb.class);
    public static final StoredValue<ChangeData> CHANGE_DATA = StoredValue.create(ChangeData.class);
    public static final StoredValue<PatchSet> PATCH_SET = StoredValue.create(PatchSet.class);
    public static final StoredValue<ChangeControl> CHANGE_CONTROL = StoredValue.create(ChangeControl.class);
    public static final StoredValue<PatchSetInfo> PATCH_SET_INFO = new StoredValue<PatchSetInfo>(){

        @Override
        public PatchSetInfo createValue(Prolog engine) {
            Change change = StoredValues.getChange(engine);
            PatchSet ps = PATCH_SET.get(engine);
            PrologEnvironment env = (PrologEnvironment)engine.control;
            PatchSetInfoFactory patchInfoFactory = env.getArgs().getPatchSetInfoFactory();
            try {
                return patchInfoFactory.get(change, ps);
            }
            catch (PatchSetInfoNotAvailableException e) {
                throw new SystemException(e.getMessage());
            }
        }
    };
    public static final StoredValue<PatchList> PATCH_LIST = new StoredValue<PatchList>(){

        @Override
        public PatchList createValue(Prolog engine) {
            PatchList patchList;
            PrologEnvironment env = (PrologEnvironment)engine.control;
            PatchSetInfo psInfo = PATCH_SET_INFO.get(engine);
            PatchListCache plCache = env.getArgs().getPatchListCache();
            Change change = StoredValues.getChange(engine);
            Project.NameKey projectKey = change.getProject();
            AnyObjectId a = null;
            ObjectId b = ObjectId.fromString(psInfo.getRevId());
            AccountDiffPreference.Whitespace ws = AccountDiffPreference.Whitespace.IGNORE_NONE;
            PatchListKey plKey = new PatchListKey(projectKey, a, b, ws);
            try {
                patchList = plCache.get(plKey);
            }
            catch (PatchListNotAvailableException e) {
                throw new SystemException("Cannot create " + plKey);
            }
            return patchList;
        }
    };
    public static final StoredValue<Repository> REPOSITORY = new StoredValue<Repository>(){

        @Override
        public Repository createValue(Prolog engine) {
            Repository repo;
            PrologEnvironment env = (PrologEnvironment)engine.control;
            GitRepositoryManager gitMgr = env.getArgs().getGitRepositoryManager();
            Change change = StoredValues.getChange(engine);
            Project.NameKey projectKey = change.getProject();
            try {
                repo = gitMgr.openRepository(projectKey);
            }
            catch (IOException e) {
                throw new SystemException(e.getMessage());
            }
            env.addToCleanup(new Runnable(){

                @Override
                public void run() {
                    repo.close();
                }
            });
            return repo;
        }
    };
    public static final StoredValue<AnonymousUser> ANONYMOUS_USER = new StoredValue<AnonymousUser>(){

        @Override
        protected AnonymousUser createValue(Prolog engine) {
            PrologEnvironment env = (PrologEnvironment)engine.control;
            return env.getArgs().getAnonymousUser();
        }
    };
    public static final StoredValue<Map<Account.Id, IdentifiedUser>> USERS = new StoredValue<Map<Account.Id, IdentifiedUser>>(){

        @Override
        protected Map<Account.Id, IdentifiedUser> createValue(Prolog engine) {
            return Maps.newHashMap();
        }
    };

    public static Change getChange(Prolog engine) throws SystemException {
        ChangeData cd = CHANGE_DATA.get(engine);
        try {
            return cd.change();
        }
        catch (OrmException e) {
            throw new SystemException("Cannot load change " + cd.getId());
        }
    }

    private StoredValues() {
    }
}

