/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.StarredChange;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.ListGroupMembership;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.util.Providers;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiedUser
extends CurrentUser {
    private static final Logger log = LoggerFactory.getLogger(IdentifiedUser.class);
    private static final GroupMembership registeredGroups = new ListGroupMembership(ImmutableSet.of(SystemGroupBackend.ANONYMOUS_USERS, SystemGroupBackend.REGISTERED_USERS));
    private final Provider<String> canonicalUrl;
    private final AccountCache accountCache;
    private final AuthConfig authConfig;
    private final GroupBackend groupBackend;
    private final String anonymousCowardName;
    @Nullable
    private final Provider<SocketAddress> remotePeerProvider;
    @Nullable
    private final Provider<ReviewDb> dbProvider;
    private final Account.Id accountId;
    private AccountState state;
    private Set<String> emailAddresses;
    private GroupMembership effectiveGroups;
    private Set<Change.Id> starredChanges;
    private ResultSet<StarredChange> starredQuery;
    private Collection<AccountProjectWatch> notificationFilters;
    private CurrentUser realUser;

    private IdentifiedUser(CapabilityControl.Factory capabilityControlFactory, AuthConfig authConfig, String anonymousCowardName, Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend, @Nullable Provider<SocketAddress> remotePeerProvider, @Nullable Provider<ReviewDb> dbProvider, Account.Id id, @Nullable CurrentUser realUser) {
        super(capabilityControlFactory);
        this.canonicalUrl = canonicalUrl;
        this.accountCache = accountCache;
        this.groupBackend = groupBackend;
        this.authConfig = authConfig;
        this.anonymousCowardName = anonymousCowardName;
        this.remotePeerProvider = remotePeerProvider;
        this.dbProvider = dbProvider;
        this.accountId = id;
        this.realUser = realUser != null ? realUser : this;
    }

    @Override
    public CurrentUser getRealUser() {
        return this.realUser;
    }

    public AccountState state() {
        if (this.state == null) {
            this.state = this.accountCache.get(this.getAccountId());
        }
        return this.state;
    }

    public Account.Id getAccountId() {
        return this.accountId;
    }

    @Override
    public String getUserName() {
        return this.state().getUserName();
    }

    public Account getAccount() {
        return this.state().getAccount();
    }

    public AccountDiffPreference getAccountDiffPreference() {
        AccountDiffPreference diffPref;
        try {
            diffPref = this.dbProvider.get().accountDiffPreferences().get(this.getAccountId());
            if (diffPref == null) {
                diffPref = AccountDiffPreference.createDefault(this.getAccountId());
            }
        }
        catch (OrmException e) {
            log.warn("Cannot query account diff preferences", e);
            diffPref = AccountDiffPreference.createDefault(this.getAccountId());
        }
        return diffPref;
    }

    public Set<String> getEmailAddresses() {
        if (this.emailAddresses == null) {
            this.emailAddresses = this.state().getEmailAddresses();
        }
        return this.emailAddresses;
    }

    public String getName() {
        return new AccountInfo(this.getAccount()).getName(this.anonymousCowardName);
    }

    public String getNameEmail() {
        return new AccountInfo(this.getAccount()).getNameEmail(this.anonymousCowardName);
    }

    @Override
    public GroupMembership getEffectiveGroups() {
        if (this.effectiveGroups == null) {
            this.effectiveGroups = this.authConfig.isIdentityTrustable(this.state().getExternalIds()) ? this.groupBackend.membershipsOf(this) : registeredGroups;
        }
        return this.effectiveGroups;
    }

    @Override
    public Set<Change.Id> getStarredChanges() {
        if (this.starredChanges == null) {
            if (this.dbProvider == null) {
                throw new OutOfScopeException("Not in request scoped user");
            }
            HashSet<Change.Id> h = Sets.newHashSet();
            try {
                if (this.starredQuery != null) {
                    for (StarredChange sc : this.starredQuery) {
                        h.add(sc.getChangeId());
                    }
                    this.starredQuery = null;
                } else {
                    for (StarredChange sc : this.dbProvider.get().starredChanges().byAccount(this.getAccountId())) {
                        h.add(sc.getChangeId());
                    }
                }
            }
            catch (OrmException e) {
                log.warn("Cannot query starred by user changes", e);
            }
            this.starredChanges = Collections.unmodifiableSet(h);
        }
        return this.starredChanges;
    }

    public void asyncStarredChanges() {
        if (this.starredChanges == null && this.dbProvider != null) {
            try {
                this.starredQuery = this.dbProvider.get().starredChanges().byAccount(this.getAccountId());
            }
            catch (OrmException e) {
                log.warn("Cannot query starred by user changes", e);
                this.starredQuery = null;
                this.starredChanges = Collections.emptySet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortStarredChanges() {
        if (this.starredQuery != null) {
            try {
                this.starredQuery.close();
            }
            finally {
                this.starredQuery = null;
            }
        }
    }

    @Override
    public Collection<AccountProjectWatch> getNotificationFilters() {
        if (this.notificationFilters == null) {
            List<Object> r;
            if (this.dbProvider == null) {
                throw new OutOfScopeException("Not in request scoped user");
            }
            try {
                r = this.dbProvider.get().accountProjectWatches().byAccount(this.getAccountId()).toList();
            }
            catch (OrmException e) {
                log.warn("Cannot query notification filters of a user", e);
                r = Collections.emptyList();
            }
            this.notificationFilters = Collections.unmodifiableList(r);
        }
        return this.notificationFilters;
    }

    public PersonIdent newRefLogIdent() {
        return this.newRefLogIdent(new Date(), TimeZone.getDefault());
    }

    public PersonIdent newRefLogIdent(Date when, TimeZone tz) {
        SocketAddress remotePeer;
        String user;
        Account ua = this.getAccount();
        String name = ua.getFullName();
        if (name == null || name.isEmpty()) {
            name = ua.getPreferredEmail();
        }
        if (name == null || name.isEmpty()) {
            name = this.anonymousCowardName;
        }
        if ((user = this.getUserName()) == null) {
            user = "";
        }
        user = user + "|" + "account-" + ua.getId().toString();
        String host = null;
        if (this.remotePeerProvider != null && (remotePeer = this.remotePeerProvider.get()) instanceof InetSocketAddress) {
            InetSocketAddress sa = (InetSocketAddress)remotePeer;
            InetAddress in = sa.getAddress();
            String string = host = in != null ? in.getCanonicalHostName() : sa.getHostName();
        }
        if (host == null || host.isEmpty()) {
            host = "unknown";
        }
        return new PersonIdent(name, user + "@" + host, when, tz);
    }

    public PersonIdent newCommitterIdent(Date when, TimeZone tz) {
        Account ua = this.getAccount();
        String name = ua.getFullName();
        String email = ua.getPreferredEmail();
        if (email == null || email.isEmpty()) {
            String host;
            String user = this.getUserName();
            if (user == null || user.isEmpty()) {
                user = "account-" + ua.getId().toString();
            }
            if (this.canonicalUrl.get() != null) {
                try {
                    host = new URL(this.canonicalUrl.get()).getHost();
                }
                catch (MalformedURLException e) {
                    host = SystemReader.getInstance().getHostname();
                }
            } else {
                host = SystemReader.getInstance().getHostname();
            }
            email = user + "@" + host;
        }
        if (name == null || name.isEmpty()) {
            int at = email.indexOf(64);
            name = 0 < at ? email.substring(0, at) : this.anonymousCowardName;
        }
        return new PersonIdent(name, email, when, tz);
    }

    public String toString() {
        return "IdentifiedUser[account " + this.getAccountId() + "]";
    }

    @Override
    public boolean isIdentifiedUser() {
        return true;
    }

    @Singleton
    public static class RequestFactory {
        private final CapabilityControl.Factory capabilityControlFactory;
        private final AuthConfig authConfig;
        private final String anonymousCowardName;
        private final Provider<String> canonicalUrl;
        private final AccountCache accountCache;
        private final GroupBackend groupBackend;
        private final Provider<SocketAddress> remotePeerProvider;
        private final Provider<ReviewDb> dbProvider;

        @Inject
        RequestFactory(CapabilityControl.Factory capabilityControlFactory, AuthConfig authConfig, @AnonymousCowardName String anonymousCowardName, @CanonicalWebUrl Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend, @RemotePeer Provider<SocketAddress> remotePeerProvider, Provider<ReviewDb> dbProvider) {
            this.capabilityControlFactory = capabilityControlFactory;
            this.authConfig = authConfig;
            this.anonymousCowardName = anonymousCowardName;
            this.canonicalUrl = canonicalUrl;
            this.accountCache = accountCache;
            this.groupBackend = groupBackend;
            this.remotePeerProvider = remotePeerProvider;
            this.dbProvider = dbProvider;
        }

        public IdentifiedUser create(Account.Id id) {
            return new IdentifiedUser(this.capabilityControlFactory, this.authConfig, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.remotePeerProvider, this.dbProvider, id, null);
        }

        public IdentifiedUser runAs(Account.Id id, CurrentUser caller) {
            return new IdentifiedUser(this.capabilityControlFactory, this.authConfig, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.remotePeerProvider, this.dbProvider, id, caller);
        }
    }

    @Singleton
    public static class GenericFactory {
        private final CapabilityControl.Factory capabilityControlFactory;
        private final AuthConfig authConfig;
        private final String anonymousCowardName;
        private final Provider<String> canonicalUrl;
        private final AccountCache accountCache;
        private final GroupBackend groupBackend;

        @Inject
        public GenericFactory(@Nullable CapabilityControl.Factory capabilityControlFactory, AuthConfig authConfig, @AnonymousCowardName String anonymousCowardName, @CanonicalWebUrl Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend) {
            this.capabilityControlFactory = capabilityControlFactory;
            this.authConfig = authConfig;
            this.anonymousCowardName = anonymousCowardName;
            this.canonicalUrl = canonicalUrl;
            this.accountCache = accountCache;
            this.groupBackend = groupBackend;
        }

        public IdentifiedUser create(Account.Id id) {
            return this.create((SocketAddress)null, id);
        }

        public IdentifiedUser create(Provider<ReviewDb> db, Account.Id id) {
            return new IdentifiedUser(this.capabilityControlFactory, this.authConfig, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, null, db, id, null);
        }

        public IdentifiedUser create(SocketAddress remotePeer, Account.Id id) {
            return new IdentifiedUser(this.capabilityControlFactory, this.authConfig, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, Providers.of(remotePeer), null, id, null);
        }

        public CurrentUser runAs(SocketAddress remotePeer, Account.Id id, @Nullable CurrentUser caller) {
            return new IdentifiedUser(this.capabilityControlFactory, this.authConfig, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, Providers.of(remotePeer), null, id, caller);
        }
    }
}

