/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.webui.PatchSetWebLink;
import com.google.gerrit.extensions.webui.ProjectWebLink;
import java.util.ArrayList;

public class WebLinks {
    private final DynamicSet<PatchSetWebLink> patchSetLinks;
    private final DynamicSet<ProjectWebLink> projectLinks;

    public WebLinks(DynamicSet<PatchSetWebLink> patchSetLinks, DynamicSet<ProjectWebLink> projectLinks) {
        this.patchSetLinks = patchSetLinks;
        this.projectLinks = projectLinks;
    }

    public Iterable<WebLinkInfo> getPatchSetLinks(String project, String commit) {
        ArrayList<WebLinkInfo> links = Lists.newArrayList();
        for (PatchSetWebLink webLink : this.patchSetLinks) {
            links.add(new WebLinkInfo(webLink.getLinkName(), webLink.getPatchSetUrl(project, commit)));
        }
        return links;
    }

    public Iterable<WebLinkInfo> getProjectLinks(String project) {
        ArrayList<WebLinkInfo> links = Lists.newArrayList();
        for (ProjectWebLink webLink : this.projectLinks) {
            links.add(new WebLinkInfo(webLink.getLinkName(), webLink.getProjectUrl(project)));
        }
        return links;
    }
}

