/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountCache;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AccountInfoCacheFactory {
    private final AccountCache accountCache;
    private final Map<Account.Id, Account> out;

    @Inject
    AccountInfoCacheFactory(AccountCache accountCache) {
        this.accountCache = accountCache;
        this.out = new HashMap<Account.Id, Account>();
    }

    public void want(Account.Id id) {
        if (id != null && !this.out.containsKey(id)) {
            this.out.put(id, this.accountCache.get(id).getAccount());
        }
    }

    public void want(Iterable<Account.Id> ids) {
        for (Account.Id id : ids) {
            this.want(id);
        }
    }

    public Account get(Account.Id id) {
        this.want(id);
        return this.out.get(id);
    }

    public AccountInfoCache create() {
        ArrayList<AccountInfo> r = new ArrayList<AccountInfo>(this.out.size());
        for (Account a : this.out.values()) {
            r.add(new AccountInfo(a));
        }
        return new AccountInfoCache(r);
    }

    public static interface Factory {
        public AccountInfoCacheFactory create();
    }
}

