/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

@Singleton
public class AddSshKey
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;
    private final SshKeyCache sshKeyCache;

    @Inject
    AddSshKey(Provider<CurrentUser> self, Provider<ReviewDb> dbProvider, SshKeyCache sshKeyCache) {
        this.self = self;
        this.dbProvider = dbProvider;
        this.sshKeyCache = sshKeyCache;
    }

    public Response<GetSshKeys.SshKeyInfo> apply(AccountResource rsrc, Input input) throws AuthException, BadRequestException, OrmException, IOException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to add SSH keys");
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<GetSshKeys.SshKeyInfo> apply(IdentifiedUser user, Input input) throws BadRequestException, OrmException, IOException {
        if (input == null) {
            input = new Input();
        }
        if (input.raw == null) {
            throw new BadRequestException("SSH public key missing");
        }
        ResultSet<AccountSshKey> byAccountLast = this.dbProvider.get().accountSshKeys().byAccountLast(user.getAccountId());
        AccountSshKey last = Iterables.getOnlyElement(byAccountLast, null);
        int max = last == null ? 0 : last.getKey().get();
        final RawInput rawKey = input.raw;
        String sshPublicKey = new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return rawKey.getInputStream();
            }
        }.asCharSource(StandardCharsets.UTF_8).read();
        try {
            AccountSshKey sshKey = this.sshKeyCache.create(new AccountSshKey.Id(user.getAccountId(), max + 1), sshPublicKey);
            this.dbProvider.get().accountSshKeys().insert(Collections.singleton(sshKey));
            this.sshKeyCache.evict(user.getUserName());
            return Response.created(new GetSshKeys.SshKeyInfo(sshKey));
        }
        catch (InvalidSshKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    public static class Input {
        public RawInput raw;
    }
}

