/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.GetEmails;
import com.google.gerrit.server.account.PutPreferred;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.mail.RegisterNewEmailSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEmail
implements RestModifyView<AccountResource, Input> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final AuthConfig authConfig;
    private final AccountManager accountManager;
    private final RegisterNewEmailSender.Factory registerNewEmailFactory;
    private final PutPreferred putPreferred;
    private final String email;

    @Inject
    CreateEmail(Provider<CurrentUser> self, Realm realm, AuthConfig authConfig, AccountManager accountManager, RegisterNewEmailSender.Factory registerNewEmailFactory, PutPreferred putPreferred, @Assisted String email) {
        this.self = self;
        this.realm = realm;
        this.authConfig = authConfig;
        this.accountManager = accountManager;
        this.registerNewEmailFactory = registerNewEmailFactory;
        this.putPreferred = putPreferred;
        this.email = email;
    }

    public Response<GetEmails.EmailInfo> apply(AccountResource rsrc, Input input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, OrmException, EmailException, MethodNotAllowedException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to add email address");
        }
        if (input == null) {
            input = new Input();
        }
        if (!EmailValidator.getInstance().isValid(this.email)) {
            throw new BadRequestException("invalid email address");
        }
        if (input.noConfirmation && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("must be administrator to use no_confirmation");
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<GetEmails.EmailInfo> apply(IdentifiedUser user, Input input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, OrmException, EmailException, MethodNotAllowedException {
        if (!this.realm.allowsEdit(Account.FieldName.REGISTER_NEW_EMAIL)) {
            throw new MethodNotAllowedException("realm does not allow adding emails");
        }
        if (input.email != null && !this.email.equals(input.email)) {
            throw new BadRequestException("email address must match URL");
        }
        GetEmails.EmailInfo info = new GetEmails.EmailInfo();
        info.email = this.email;
        if (input.noConfirmation || this.authConfig.getAuthType() == AuthType.DEVELOPMENT_BECOME_ANY_ACCOUNT) {
            try {
                this.accountManager.link(user.getAccountId(), AuthRequest.forEmail(this.email));
            }
            catch (AccountException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            if (input.preferred) {
                this.putPreferred.apply(new AccountResource.Email(user, this.email), null);
                info.preferred = true;
            }
        } else {
            try {
                this.registerNewEmailFactory.create(this.email).send();
                info.pendingConfirmation = true;
            }
            catch (EmailException | RuntimeException e) {
                this.log.error("Cannot send email verification message to " + this.email, e);
                throw e;
            }
        }
        return Response.created(info);
    }

    public static interface Factory {
        public CreateEmail create(String var1);
    }

    public static class Input {
        @DefaultInput
        public String email;
        public boolean preferred;
        public boolean noConfirmation;
    }
}

