/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@RequiresCapability(value="administrateServer")
@Singleton
public class DeleteActive
implements RestModifyView<AccountResource, Input> {
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache byIdCache;

    @Inject
    DeleteActive(Provider<ReviewDb> dbProvider, AccountCache byIdCache) {
        this.dbProvider = dbProvider;
        this.byIdCache = byIdCache;
    }

    public Response<?> apply(AccountResource rsrc, Input input) throws ResourceNotFoundException, OrmException {
        Account a = this.dbProvider.get().accounts().get(rsrc.getUser().getAccountId());
        if (a == null) {
            throw new ResourceNotFoundException("account not found");
        }
        if (!a.isActive()) {
            throw new ResourceNotFoundException();
        }
        a.setActive(false);
        this.dbProvider.get().accounts().update(Collections.singleton(a));
        this.byIdCache.evict(a.getId());
        return Response.none();
    }

    public static class Input {
    }
}

