/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GetDiffPreferences
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> db;

    @Inject
    GetDiffPreferences(Provider<CurrentUser> self, Provider<ReviewDb> db) {
        this.self = self;
        this.db = db;
    }

    public DiffPreferencesInfo apply(AccountResource rsrc) throws AuthException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        Account.Id userId = rsrc.getUser().getAccountId();
        AccountDiffPreference a = this.db.get().accountDiffPreferences().get(userId);
        if (a == null) {
            a = new AccountDiffPreference(userId);
        }
        return DiffPreferencesInfo.parse(a);
    }

    public static class DiffPreferencesInfo {
        public short context;
        public Boolean expandAllComments;
        public AccountDiffPreference.Whitespace ignoreWhitespace;
        public Boolean intralineDifference;
        public int lineLength;
        public Boolean manualReview;
        public Boolean retainHeader;
        public Boolean showLineEndings;
        public Boolean showTabs;
        public Boolean showWhitespaceErrors;
        public Boolean skipDeleted;
        public Boolean skipUncommented;
        public Boolean syntaxHighlighting;
        public Boolean hideTopMenu;
        public Boolean hideLineNumbers;
        public Boolean renderEntireFile;
        public Boolean hideEmptyPane;
        public int tabSize;
        public AccountDiffPreference.Theme theme;

        static DiffPreferencesInfo parse(AccountDiffPreference p) {
            DiffPreferencesInfo info = new DiffPreferencesInfo();
            info.context = p.getContext();
            info.expandAllComments = p.isExpandAllComments() ? Boolean.valueOf(true) : null;
            info.ignoreWhitespace = p.getIgnoreWhitespace();
            info.intralineDifference = p.isIntralineDifference() ? Boolean.valueOf(true) : null;
            info.lineLength = p.getLineLength();
            info.manualReview = p.isManualReview() ? Boolean.valueOf(true) : null;
            info.retainHeader = p.isRetainHeader() ? Boolean.valueOf(true) : null;
            info.showLineEndings = p.isShowLineEndings() ? Boolean.valueOf(true) : null;
            info.showTabs = p.isShowTabs() ? Boolean.valueOf(true) : null;
            info.showWhitespaceErrors = p.isShowWhitespaceErrors() ? Boolean.valueOf(true) : null;
            info.skipDeleted = p.isSkipDeleted() ? Boolean.valueOf(true) : null;
            info.skipUncommented = p.isSkipUncommented() ? Boolean.valueOf(true) : null;
            info.hideTopMenu = p.isHideTopMenu() ? Boolean.valueOf(true) : null;
            info.hideLineNumbers = p.isHideLineNumbers() ? Boolean.valueOf(true) : null;
            info.syntaxHighlighting = p.isSyntaxHighlighting() ? Boolean.valueOf(true) : null;
            info.tabSize = p.getTabSize();
            info.renderEntireFile = p.isRenderEntireFile() ? Boolean.valueOf(true) : null;
            info.hideEmptyPane = p.isHideEmptyPane() ? Boolean.valueOf(true) : null;
            info.theme = p.getTheme();
            return info;
        }
    }
}

