/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AccountState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GetHttpPassword
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;

    @Inject
    GetHttpPassword(Provider<CurrentUser> self) {
        this.self = self;
    }

    public String apply(AccountResource rsrc) throws AuthException, ResourceNotFoundException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to get http password");
        }
        AccountState s = rsrc.getUser().state();
        if (s.getUserName() == null) {
            throw new ResourceNotFoundException();
        }
        String p = s.getPassword(s.getUserName());
        if (p == null) {
            throw new ResourceNotFoundException();
        }
        return p;
    }
}

