/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupMembership;
import java.util.Set;

public class ListGroupMembership
implements GroupMembership {
    private final Set<AccountGroup.UUID> groups;

    public ListGroupMembership(Iterable<AccountGroup.UUID> groupIds) {
        this.groups = ImmutableSet.copyOf(groupIds);
    }

    @Override
    public boolean contains(AccountGroup.UUID groupId) {
        return this.groups.contains(groupId);
    }

    @Override
    public boolean containsAnyOf(Iterable<AccountGroup.UUID> groupIds) {
        for (AccountGroup.UUID groupId : groupIds) {
            if (!this.contains(groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<AccountGroup.UUID> intersection(Iterable<AccountGroup.UUID> groupIds) {
        return Sets.intersection(ImmutableSet.copyOf(groupIds), this.groups);
    }

    @Override
    public Set<AccountGroup.UUID> getKnownGroups() {
        return Sets.newHashSet(this.groups);
    }
}

