/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.git.RenameGroupOp;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class PerformRenameGroup {
    private final ReviewDb db;
    private final GroupCache groupCache;
    private final GroupControl.Factory groupControlFactory;
    private final GroupDetailFactory.Factory groupDetailFactory;
    private final RenameGroupOp.Factory renameGroupOpFactory;
    private final IdentifiedUser currentUser;

    @Inject
    PerformRenameGroup(ReviewDb db, GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupDetailFactory.Factory groupDetailFactory, RenameGroupOp.Factory renameGroupOpFactory, IdentifiedUser currentUser) {
        this.db = db;
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.groupDetailFactory = groupDetailFactory;
        this.renameGroupOpFactory = renameGroupOpFactory;
        this.currentUser = currentUser;
    }

    public GroupDetail renameGroup(String groupName, String newGroupName) throws OrmException, NameAlreadyUsedException, NoSuchGroupException, InvalidNameException {
        AccountGroup.NameKey groupNameKey = new AccountGroup.NameKey(groupName);
        AccountGroup group = this.groupCache.get(groupNameKey);
        if (group == null) {
            throw new NoSuchGroupException(groupNameKey);
        }
        return this.renameGroup(group.getId(), newGroupName);
    }

    public GroupDetail renameGroup(AccountGroup.Id groupId, String newName) throws OrmException, NameAlreadyUsedException, NoSuchGroupException, InvalidNameException {
        GroupControl ctl = this.groupControlFactory.validateFor(groupId);
        AccountGroup group = this.db.accountGroups().get(groupId);
        if (group == null || !ctl.isOwner()) {
            throw new NoSuchGroupException(groupId);
        }
        if (newName.trim().isEmpty()) {
            throw new InvalidNameException();
        }
        AccountGroup.NameKey old = group.getNameKey();
        AccountGroup.NameKey key = new AccountGroup.NameKey(newName);
        try {
            AccountGroupName id = new AccountGroupName(key, groupId);
            this.db.accountGroupNames().insert(Collections.singleton(id));
        }
        catch (OrmException e) {
            AccountGroupName other = this.db.accountGroupNames().get(key);
            if (other != null) {
                if (other.getId().equals(groupId)) {
                    return this.groupDetailFactory.create(groupId).call();
                }
                throw new NameAlreadyUsedException(newName);
            }
            throw e;
        }
        group.setNameKey(key);
        this.db.accountGroups().update(Collections.singleton(group));
        AccountGroupName priorName = this.db.accountGroupNames().get(old);
        if (priorName != null) {
            this.db.accountGroupNames().delete(Collections.singleton(priorName));
        }
        this.groupCache.evict(group);
        this.groupCache.evictAfterRename(old, key);
        this.renameGroupOpFactory.create(this.currentUser.newCommitterIdent(new Date(), TimeZone.getDefault()), group.getGroupUUID(), old.get(), newName).start(0L, TimeUnit.MILLISECONDS);
        return this.groupDetailFactory.create(groupId).call();
    }

    public static interface Factory {
        public PerformRenameGroup create();
    }
}

