/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.TopMenu;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class SetPreferences
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final AccountCache cache;
    private final Provider<ReviewDb> db;
    private final MetaDataUpdate.User metaDataUpdateFactory;
    private final AllUsersName allUsersName;

    @Inject
    SetPreferences(Provider<CurrentUser> self, AccountCache cache, Provider<ReviewDb> db, MetaDataUpdate.User metaDataUpdateFactory, AllUsersName allUsersName) {
        this.self = self;
        this.cache = cache;
        this.db = db;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetPreferences.PreferenceInfo apply(AccountResource rsrc, Input i) throws AuthException, ResourceNotFoundException, OrmException, IOException, ConfigInvalidException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        if (i == null) {
            i = new Input();
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        MetaDataUpdate md = this.metaDataUpdateFactory.create(this.allUsersName);
        this.db.get().accounts().beginTransaction(accountId);
        try {
            Account a = this.db.get().accounts().get(accountId);
            if (a == null) {
                throw new ResourceNotFoundException();
            }
            VersionedAccountPreferences versionedPrefs = VersionedAccountPreferences.forUser(accountId);
            versionedPrefs.load(md);
            AccountGeneralPreferences p = a.getGeneralPreferences();
            if (p == null) {
                p = new AccountGeneralPreferences();
                a.setGeneralPreferences(p);
            }
            if (i.changesPerPage != null) {
                p.setMaximumPageSize(i.changesPerPage);
            }
            if (i.showSiteHeader != null) {
                p.setShowSiteHeader(i.showSiteHeader);
            }
            if (i.useFlashClipboard != null) {
                p.setUseFlashClipboard(i.useFlashClipboard);
            }
            if (i.downloadScheme != null) {
                p.setDownloadUrl(i.downloadScheme);
            }
            if (i.downloadCommand != null) {
                p.setDownloadCommand(i.downloadCommand);
            }
            if (i.copySelfOnEmail != null) {
                p.setCopySelfOnEmails(i.copySelfOnEmail);
            }
            if (i.dateFormat != null) {
                p.setDateFormat(i.dateFormat);
            }
            if (i.timeFormat != null) {
                p.setTimeFormat(i.timeFormat);
            }
            if (i.reversePatchSetOrder != null) {
                p.setReversePatchSetOrder(i.reversePatchSetOrder);
            }
            if (i.relativeDateInChangeTable != null) {
                p.setRelativeDateInChangeTable(i.relativeDateInChangeTable);
            }
            if (i.sizeBarInChangeTable != null) {
                p.setSizeBarInChangeTable(i.sizeBarInChangeTable);
            }
            if (i.legacycidInChangeTable != null) {
                p.setLegacycidInChangeTable(i.legacycidInChangeTable);
            }
            if (i.reviewCategoryStrategy != null) {
                p.setReviewCategoryStrategy(i.reviewCategoryStrategy);
            }
            if (i.commentVisibilityStrategy != null) {
                p.setCommentVisibilityStrategy(i.commentVisibilityStrategy);
            }
            if (i.diffView != null) {
                p.setDiffView(i.diffView);
            }
            if (i.changeScreen != null) {
                p.setChangeScreen(i.changeScreen);
            }
            this.db.get().accounts().update(Collections.singleton(a));
            this.db.get().commit();
            SetPreferences.storeMyMenus(versionedPrefs, i.my);
            versionedPrefs.commit(md);
            this.cache.evict(accountId);
            GetPreferences.PreferenceInfo preferenceInfo = new GetPreferences.PreferenceInfo(p, versionedPrefs, md.getRepository());
            return preferenceInfo;
        }
        finally {
            md.close();
            this.db.get().rollback();
        }
    }

    public static void storeMyMenus(VersionedAccountPreferences prefs, List<TopMenu.MenuItem> my) {
        Config cfg = prefs.getConfig();
        if (my != null) {
            SetPreferences.unsetSection(cfg, "my");
            for (TopMenu.MenuItem item : my) {
                SetPreferences.set(cfg, item.name, "url", item.url);
                SetPreferences.set(cfg, item.name, "target", item.target);
                SetPreferences.set(cfg, item.name, "id", item.id);
            }
        }
    }

    private static void set(Config cfg, String section, String key, String val) {
        if (Strings.isNullOrEmpty(val)) {
            cfg.unset("my", section, key);
        } else {
            cfg.setString("my", section, key, val);
        }
    }

    private static void unsetSection(Config cfg, String section) {
        cfg.unsetSection(section, null);
        for (String subsection : cfg.getSubsections(section)) {
            cfg.unsetSection(section, subsection);
        }
    }

    public static class Input {
        public Short changesPerPage;
        public Boolean showSiteHeader;
        public Boolean useFlashClipboard;
        public AccountGeneralPreferences.DownloadScheme downloadScheme;
        public AccountGeneralPreferences.DownloadCommand downloadCommand;
        public Boolean copySelfOnEmail;
        public AccountGeneralPreferences.DateFormat dateFormat;
        public AccountGeneralPreferences.TimeFormat timeFormat;
        public Boolean reversePatchSetOrder;
        public Boolean relativeDateInChangeTable;
        public Boolean sizeBarInChangeTable;
        public Boolean legacycidInChangeTable;
        public AccountGeneralPreferences.CommentVisibilityStrategy commentVisibilityStrategy;
        public AccountGeneralPreferences.ReviewCategoryStrategy reviewCategoryStrategy;
        public AccountGeneralPreferences.DiffView diffView;
        public AccountGeneralPreferences.ChangeScreen changeScreen;
        public List<TopMenu.MenuItem> my;
    }
}

