/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class SshKeys
implements ChildCollection<AccountResource, AccountResource.SshKey> {
    private final DynamicMap<RestView<AccountResource.SshKey>> views;
    private final GetSshKeys list;
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    SshKeys(DynamicMap<RestView<AccountResource.SshKey>> views, GetSshKeys list, Provider<CurrentUser> self, Provider<ReviewDb> dbProvider) {
        this.views = views;
        this.list = list;
        this.self = self;
        this.dbProvider = dbProvider;
    }

    @Override
    public RestView<AccountResource> list() {
        return this.list;
    }

    @Override
    public AccountResource.SshKey parse(AccountResource rsrc, IdString id) throws ResourceNotFoundException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new ResourceNotFoundException();
        }
        return this.parse(rsrc.getUser(), id);
    }

    @Override
    public AccountResource.SshKey parse(IdentifiedUser user, IdString id) throws ResourceNotFoundException, OrmException {
        try {
            int seq = Integer.parseInt(id.get(), 10);
            AccountSshKey sshKey = this.dbProvider.get().accountSshKeys().get(new AccountSshKey.Id(user.getAccountId(), seq));
            if (sshKey == null) {
                throw new ResourceNotFoundException(id);
            }
            return new AccountResource.SshKey(user, sshKey);
        }
        catch (NumberFormatException e) {
            throw new ResourceNotFoundException(id);
        }
    }

    @Override
    public DynamicMap<RestView<AccountResource.SshKey>> views() {
        return this.views;
    }
}

