/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.git.VersionedMetaData;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;

public class VersionedAccountPreferences
extends VersionedMetaData {
    private static final String REFS_USER_DEFAULT = "refs/users/default";
    private static final String PREFERENCES = "preferences.config";
    private final String ref;
    private Config cfg;

    public static VersionedAccountPreferences forUser(Account.Id id) {
        return new VersionedAccountPreferences(RefNames.refsUsers(id));
    }

    public static VersionedAccountPreferences forDefault() {
        return new VersionedAccountPreferences(REFS_USER_DEFAULT);
    }

    private VersionedAccountPreferences(String ref) {
        this.ref = ref;
    }

    public boolean isDefaults() {
        return REFS_USER_DEFAULT.equals(this.getRefName());
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    public Config getConfig() {
        return this.cfg;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.cfg = this.readConfig(PREFERENCES);
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        if (Strings.isNullOrEmpty(commit.getMessage())) {
            commit.setMessage("Updated preferences\n");
        }
        this.saveConfig(PREFERENCES, this.cfg);
        return true;
    }
}

