/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.accounts;

import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.StarredChanges;
import com.google.gerrit.server.api.accounts.AccountInfoMapper;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class AccountApiImpl
extends AccountApi.NotImplemented
implements AccountApi {
    private final AccountResource account;
    private final ChangesCollection changes;
    private final AccountInfo.Loader.Factory accountLoaderFactory;
    private final StarredChanges.Create starredChangesCreate;
    private final StarredChanges.Delete starredChangesDelete;

    @Inject
    AccountApiImpl(AccountInfo.Loader.Factory ailf, ChangesCollection changes, StarredChanges.Create starredChangesCreate, StarredChanges.Delete starredChangesDelete, @Assisted AccountResource account) {
        this.account = account;
        this.accountLoaderFactory = ailf;
        this.changes = changes;
        this.starredChangesCreate = starredChangesCreate;
        this.starredChangesDelete = starredChangesDelete;
    }

    @Override
    public com.google.gerrit.extensions.common.AccountInfo get() throws RestApiException {
        AccountInfo.Loader accountLoader = this.accountLoaderFactory.create(true);
        try {
            AccountInfo ai = accountLoader.get(this.account.getUser().getAccountId());
            accountLoader.fill();
            return AccountInfoMapper.fromAcountInfo(ai);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse change", e);
        }
    }

    @Override
    public void starChange(String id) throws RestApiException {
        try {
            ChangeResource rsrc = this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(id));
            this.starredChangesCreate.setChange(rsrc);
            this.starredChangesCreate.apply(this.account, new StarredChanges.EmptyInput());
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot star change", e);
        }
    }

    @Override
    public void unstarChange(String id) throws RestApiException {
        try {
            ChangeResource rsrc = this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(id));
            AccountResource.StarredChange starredChange = new AccountResource.StarredChange(this.account.getUser(), rsrc);
            this.starredChangesDelete.apply(starredChange, new StarredChanges.EmptyInput());
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot unstar change", e);
        }
    }

    static interface Factory {
        public AccountApiImpl create(AccountResource var1);
    }
}

