/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.change.CherryPick;
import com.google.gerrit.server.change.DeleteDraftPatchSet;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.Files;
import com.google.gerrit.server.change.PostReview;
import com.google.gerrit.server.change.Publish;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.Reviewed;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.changedetail.RebaseChange;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Set;

class RevisionApiImpl
extends RevisionApi.NotImplemented
implements RevisionApi {
    private final Changes changes;
    private final CherryPick cherryPick;
    private final DeleteDraftPatchSet deleteDraft;
    private final Rebase rebase;
    private final RebaseChange rebaseChange;
    private final Submit submit;
    private final Publish publish;
    private final Reviewed.PutReviewed putReviewed;
    private final Reviewed.DeleteReviewed deleteReviewed;
    private final RevisionResource revision;
    private final Provider<Files> files;
    private final Provider<Files.ListFiles> listFiles;
    private final Provider<PostReview> review;

    @Inject
    RevisionApiImpl(Changes changes, CherryPick cherryPick, DeleteDraftPatchSet deleteDraft, Rebase rebase, RebaseChange rebaseChange, Submit submit, Publish publish, Reviewed.PutReviewed putReviewed, Reviewed.DeleteReviewed deleteReviewed, Provider<Files> files, Provider<Files.ListFiles> listFiles, Provider<PostReview> review, @Assisted RevisionResource r) {
        this.changes = changes;
        this.cherryPick = cherryPick;
        this.deleteDraft = deleteDraft;
        this.rebase = rebase;
        this.rebaseChange = rebaseChange;
        this.review = review;
        this.submit = submit;
        this.publish = publish;
        this.files = files;
        this.putReviewed = putReviewed;
        this.deleteReviewed = deleteReviewed;
        this.listFiles = listFiles;
        this.revision = r;
    }

    @Override
    public void review(ReviewInput in) throws RestApiException {
        try {
            this.review.get().apply(this.revision, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot post review", e);
        }
    }

    @Override
    public void submit() throws RestApiException {
        SubmitInput in = new SubmitInput();
        in.waitForMerge = true;
        this.submit(in);
    }

    @Override
    public void submit(SubmitInput in) throws RestApiException {
        try {
            this.submit.apply(this.revision, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot submit change", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        try {
            this.publish.apply(this.revision, new Publish.Input());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot publish draft patch set", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteDraft.apply(this.revision, null);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete draft ps", e);
        }
    }

    @Override
    public ChangeApi rebase() throws RestApiException {
        try {
            return this.changes.id(this.rebase.apply((RevisionResource)this.revision, null)._number);
        }
        catch (EmailException | OrmException e) {
            throw new RestApiException("Cannot rebase ps", e);
        }
    }

    @Override
    public boolean canRebase() {
        return this.rebaseChange.canRebase(this.revision);
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput in) throws RestApiException {
        try {
            return this.changes.id(this.cherryPick.apply((RevisionResource)this.revision, (CherryPickInput)in)._number);
        }
        catch (EmailException | OrmException | IOException e) {
            throw new RestApiException("Cannot cherry pick", e);
        }
    }

    @Override
    public void setReviewed(String path, boolean reviewed) throws RestApiException {
        try {
            RestModifyView<FileResource, Reviewed.Input> view = reviewed ? this.putReviewed : this.deleteReviewed;
            view.apply(this.files.get().parse(this.revision, IdString.fromDecoded(path)), new Reviewed.Input());
        }
        catch (Exception e) {
            throw new RestApiException("Cannot update reviewed flag", e);
        }
    }

    @Override
    public Set<String> reviewed() throws RestApiException {
        try {
            return ImmutableSet.copyOf((Iterable)this.listFiles.get().setReviewed(true).apply(this.revision).value());
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot list reviewed files", e);
        }
    }

    static interface Factory {
        public RevisionApiImpl create(RevisionResource var1);
    }
}

