/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.errors.ProjectCreationFailedException;
import com.google.gerrit.extensions.api.projects.BranchApi;
import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.api.projects.BranchApiImpl;
import com.google.gerrit.server.project.CreateProject;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;

public class ProjectApiImpl
extends ProjectApi.NotImplemented
implements ProjectApi {
    private final Provider<CreateProject.Factory> createProjectFactory;
    private final Factory projectApi;
    private final ProjectsCollection projects;
    private final ProjectResource project;
    private final ProjectJson projectJson;
    private final String name;
    private final BranchApiImpl.Factory branchApi;

    @AssistedInject
    ProjectApiImpl(Provider<CreateProject.Factory> createProjectFactory, Factory projectApi, ProjectsCollection projects, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, @Assisted ProjectResource project) {
        this(createProjectFactory, projectApi, projects, projectJson, branchApiFactory, project, null);
    }

    @AssistedInject
    ProjectApiImpl(Provider<CreateProject.Factory> createProjectFactory, Factory projectApi, ProjectsCollection projects, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, @Assisted String name) {
        this(createProjectFactory, projectApi, projects, projectJson, branchApiFactory, null, name);
    }

    private ProjectApiImpl(Provider<CreateProject.Factory> createProjectFactory, Factory projectApi, ProjectsCollection projects, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, ProjectResource project, String name) {
        this.createProjectFactory = createProjectFactory;
        this.projectApi = projectApi;
        this.projects = projects;
        this.projectJson = projectJson;
        this.project = project;
        this.name = name;
        this.branchApi = branchApiFactory;
    }

    @Override
    public ProjectApi create() throws RestApiException {
        return this.create(new ProjectInput());
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        try {
            if (this.name == null) {
                throw new ResourceConflictException("Project already exists");
            }
            if (in.name != null && !this.name.equals(in.name)) {
                throw new BadRequestException("name must match input.name");
            }
            this.createProjectFactory.get().create(this.name).apply(TopLevelResource.INSTANCE, in);
            return this.projectApi.create(this.projects.parse(this.name));
        }
        catch (ProjectCreationFailedException | BadRequestException | ResourceNotFoundException | UnprocessableEntityException | IOException e) {
            throw new RestApiException("Cannot create project: " + e.getMessage(), e);
        }
    }

    @Override
    public ProjectInfo get() {
        Preconditions.checkNotNull(this.project);
        return this.projectJson.format(this.project);
    }

    @Override
    public BranchApi branch(String ref) {
        return this.branchApi.create(this.project, ref);
    }

    static interface Factory {
        public ProjectApiImpl create(ProjectResource var1);

        public ProjectApiImpl create(String var1);
    }
}

