/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class AccountIdHandler
extends OptionHandler<Account.Id> {
    private final AccountResolver accountResolver;
    private final AccountManager accountManager;
    private final AuthType authType;

    @Inject
    public AccountIdHandler(AccountResolver accountResolver, AccountManager accountManager, AuthConfig authConfig, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<Account.Id> setter) {
        super(parser, option, setter);
        this.accountResolver = accountResolver;
        this.accountManager = accountManager;
        this.authType = authConfig.getAuthType();
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        Account.Id accountId;
        String token = params.getParameter(0);
        try {
            Account a = this.accountResolver.find(token);
            if (a != null) {
                accountId = a.getId();
            } else {
                switch (this.authType) {
                    case HTTP_LDAP: 
                    case CLIENT_SSL_CERT_LDAP: 
                    case LDAP: {
                        accountId = this.createAccountByLdap(token);
                        break;
                    }
                    default: {
                        throw new CmdLineException(this.owner, "user \"" + token + "\" not found");
                    }
                }
            }
        }
        catch (OrmException e) {
            throw new CmdLineException(this.owner, "database is down");
        }
        this.setter.addValue(accountId);
        return 1;
    }

    private Account.Id createAccountByLdap(String user) throws CmdLineException {
        if (!user.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$")) {
            throw new CmdLineException(this.owner, "user \"" + user + "\" not found");
        }
        try {
            AuthRequest req = AuthRequest.forUser(user);
            req.setSkipAuthentication(true);
            return this.accountManager.authenticate(req).getAccountId();
        }
        catch (AccountException e) {
            throw new CmdLineException(this.owner, "user \"" + user + "\" not found");
        }
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "EMAIL";
    }
}

