/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class PatchSetIdHandler
extends OptionHandler<PatchSet.Id> {
    @Inject
    public PatchSetIdHandler(@Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<PatchSet.Id> setter) {
        super(parser, option, setter);
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        PatchSet.Id id;
        String token = params.getParameter(0);
        try {
            id = PatchSet.Id.parse(token);
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(this.owner, "\"" + token + "\" is not a valid patch set");
        }
        this.setter.addValue(id);
        return 1;
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "CHANGE,PATCHSET";
    }
}

