/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class TimestampHandler
extends OptionHandler<Timestamp> {
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd_HHmm";

    @Inject
    public TimestampHandler(@Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<Timestamp> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String timestamp = params.getParameter(0);
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(TIMESTAMP_FORMAT);
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.setter.addValue(new Timestamp(fmt.parse(timestamp).getTime()));
            return 1;
        }
        catch (ParseException e) {
            throw new CmdLineException(this.owner, String.format("Invalid timestamp: %s; expected format: %s", timestamp, TIMESTAMP_FORMAT), e);
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        return "TIMESTAMP";
    }
}

