/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;

public class AuthUser {
    private final UUID uuid;
    private final String username;

    public AuthUser(UUID uuid, @Nullable String username) {
        this.uuid = Preconditions.checkNotNull(uuid);
        this.username = username;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    public final boolean hasUsername() {
        return this.getUsername() != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthUser) {
            return this.getUUID().equals(((AuthUser)obj).getUUID());
        }
        return false;
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public String toString() {
        return String.format("AuthUser[uuid=%s, username=%s]", this.getUUID(), this.getUsername());
    }

    public static final class UUID {
        private final String uuid;

        public UUID(String uuid) {
            this.uuid = Preconditions.checkNotNull(uuid);
        }

        public String get() {
            return this.uuid;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UUID) {
                return this.get().equals(((UUID)obj).get());
            }
            return false;
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public String toString() {
            return String.format("AuthUser.UUID[%s]", this.get());
        }
    }
}

