/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.auth.AuthBackend;
import com.google.gerrit.server.auth.AuthException;
import com.google.gerrit.server.auth.AuthRequest;
import com.google.gerrit.server.auth.AuthUser;
import com.google.gerrit.server.auth.MissingCredentialsException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class UniversalAuthBackend
implements AuthBackend {
    private final DynamicSet<AuthBackend> authBackends;

    @Inject
    UniversalAuthBackend(DynamicSet<AuthBackend> authBackends) {
        this.authBackends = authBackends;
    }

    @Override
    public AuthUser authenticate(AuthRequest request) throws AuthException {
        ArrayList<AuthUser> authUsers = Lists.newArrayList();
        ArrayList<AuthException> authExs = Lists.newArrayList();
        for (AuthBackend backend : this.authBackends) {
            try {
                authUsers.add(Preconditions.checkNotNull(backend.authenticate(request)));
            }
            catch (MissingCredentialsException ex) {
            }
            catch (AuthException ex) {
                authExs.add(ex);
            }
        }
        if (authUsers.size() == 1) {
            return (AuthUser)authUsers.get(0);
        }
        if (authUsers.isEmpty() && authExs.size() == 1) {
            throw (AuthException)authExs.get(0);
        }
        if (authExs.isEmpty() && authUsers.isEmpty()) {
            throw new MissingCredentialsException();
        }
        String msg = String.format("Multiple AuthBackends attempted to handle request: authUsers=%s authExs=%s", authUsers, authExs);
        throw new AuthException(msg);
    }

    @Override
    public String getDomain() {
        throw new UnsupportedOperationException("UniversalAuthBackend doesn't support domain.");
    }
}

