/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.gerrit.extensions.annotations.Exports;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.CacheProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class CacheModule
extends AbstractModule {
    private static final TypeLiteral<Cache<?, ?>> ANY_CACHE = new TypeLiteral<Cache<?, ?>>(){};

    protected <K, V> CacheBinding<K, V> cache(String name, Class<K> keyType, Class<V> valType) {
        return this.cache(name, TypeLiteral.get(keyType), TypeLiteral.get(valType));
    }

    protected <K, V> CacheBinding<K, V> cache(String name, Class<K> keyType, TypeLiteral<V> valType) {
        return this.cache(name, TypeLiteral.get(keyType), valType);
    }

    protected <K, V> CacheBinding<K, V> cache(String name, TypeLiteral<K> keyType, TypeLiteral<V> valType) {
        ParameterizedType type = Types.newParameterizedType(Cache.class, new Type[]{keyType.getType(), valType.getType()});
        Key<?> key = Key.get((Type)type, (Annotation)Names.named(name));
        CacheProvider<K, V> m = new CacheProvider<K, V>(this, name, keyType, valType);
        this.bind(key).toProvider((Provider<?>)m).asEagerSingleton();
        this.bind(ANY_CACHE).annotatedWith(Exports.named(name)).to(key);
        return m.maximumWeight(1024L);
    }

    <K, V> Provider<CacheLoader<K, V>> bindCacheLoader(CacheProvider<K, V> m, Class<? extends CacheLoader<K, V>> impl) {
        ParameterizedType type = Types.newParameterizedType(Cache.class, new Type[]{m.keyType().getType(), m.valueType().getType()});
        ParameterizedType loadingType = Types.newParameterizedType(LoadingCache.class, new Type[]{m.keyType().getType(), m.valueType().getType()});
        ParameterizedType loaderType = Types.newParameterizedType(CacheLoader.class, new Type[]{m.keyType().getType(), m.valueType().getType()});
        Key<?> key = Key.get((Type)type, (Annotation)Names.named(m.name));
        Key<?> loadingKey = Key.get((Type)loadingType, (Annotation)Names.named(m.name));
        Key<?> loaderKey = Key.get((Type)loaderType, (Annotation)Names.named(m.name));
        this.bind(loaderKey).to(impl).in(Scopes.SINGLETON);
        this.bind(loadingKey).to(key);
        return this.getProvider(loaderKey);
    }

    <K, V> Provider<Weigher<K, V>> bindWeigher(CacheProvider<K, V> m, Class<? extends Weigher<K, V>> impl) {
        ParameterizedType weigherType = Types.newParameterizedType(Weigher.class, new Type[]{m.keyType().getType(), m.valueType().getType()});
        Key<?> key = Key.get((Type)weigherType, (Annotation)Names.named(m.name));
        this.bind(key).to(impl).in(Scopes.SINGLETON);
        return this.getProvider(key);
    }

    protected <K extends Serializable, V extends Serializable> CacheBinding<K, V> persist(String name, Class<K> keyType, Class<V> valType) {
        return this.persist(name, TypeLiteral.get(keyType), TypeLiteral.get(valType));
    }

    protected <K extends Serializable, V extends Serializable> CacheBinding<K, V> persist(String name, Class<K> keyType, TypeLiteral<V> valType) {
        return this.persist(name, TypeLiteral.get(keyType), valType);
    }

    protected <K extends Serializable, V extends Serializable> CacheBinding<K, V> persist(String name, TypeLiteral<K> keyType, TypeLiteral<V> valType) {
        return ((CacheProvider)this.cache(name, keyType, valType)).persist(true);
    }
}

